-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  /   Vendor: Xilinx
-- \   \   \/    Version: 4.0
--  \   \        Filename: $RCSfile: floating_point_v4_0_xst_unobf.vhd,v $           
--  /   /        Date Last Modified: $Date: 2008/09/09 20:27:09 $ 
-- /___/   /\    Date Created: Dec 2005
-- \   \  /  \
--  \___\/\___\
-- 
--Device  : All
--Library : xilinxcorelib
--Purpose : Floating-point operator behavioral model
--
--------------------------------------------------------------------------------    
-- DISCLAIMER OF LIABILITY
-- 
-- This text/file contains proprietary, confidential
-- information of Xilinx, Inc., is distributed under license
-- from Xilinx, Inc., and may be used, copied and/or
-- disclosed only pursuant to the terms of a valid license
-- agreement with Xilinx, Inc. Xilinx hereby grants you 
-- a license to use this text/file solely for design, simulation, 
-- implementation and creation of design files limited 
-- to Xilinx devices or technologies. Use with non-Xilinx 
-- devices or technologies is expressly prohibited and 
-- immediately terminates your license unless covered by
-- a separate agreement.
--
-- Xilinx is providing this design, code, or information 
-- "as is" solely for use in developing programs and 
-- solutions for Xilinx devices. By providing this design, 
-- code, or information as one possible implementation of 
-- this feature, application or standard, Xilinx is making no 
-- representation that this implementation is free from any 
-- claims of infringement. You are responsible for 
-- obtaining any rights you may require for your implementation. 
-- Xilinx expressly disclaims any warranty whatsoever with 
-- respect to the adequacy of the implementation, including 
-- but not limited to any warranties or representations that this
-- implementation is free from claims of infringement, implied 
-- warranties of merchantability or fitness for a particular 
-- purpose.
--
-- Xilinx products are not intended for use in life support
-- appliances, devices, or systems. Use in such applications are
-- expressly prohibited.
-- 
--
-- Copyright (c) 2005, 2006, 2007, 2008 Xilinx, Inc. All rights reserved.
--
-- This copyright and support notice must be retained as part 
-- of this text at all times.
--------------------------------------------------------------------------------
--                               flt_pt_operator_v4_0
--  floating_point_v4_0_xst
--                                ND                 A  B
--    ND  A       B             /  |                 |  |
--    |   |       |            /   |                 |  |
--    |   |       |           /    +----------+      |  |
--  +-+---+-------+------+   /+----+----+ +---+----+ |  |
--  | Optional signals   |  / |RDY_CNTRL| |RFD_GEN | |  |
--  +---------+----------+ /  +----+----+ +---+----+ |  |
--            |           /        |          |      |  |
--  +---------+----------*    +----+----------+------+--+--+
--  |flt_pt_operator_v4_0|    |        Delay  |            |
--  +-+-------+----------*    +----+----------+------+--+--+
--    |       |           \        |          |      |  |
--    |       |            \       |          |  +---+--+--+
--   RFD/RDY RESULT         \      |          |  |Common   |
--                           \     |          |  |behaviour|
--                            \    |          |  +---------+
--                             \   |          |      |  |  / flt_pt_sqrt
--                              \ RDY       RFD  +---+--+-+  flt_pt_divide
--                               \               |Function|  flt_pt_multiply
--                                               +----+---+  flt_pt_add
--                                                    |  \   flt_pt_flt_to_fix
--                                                    |   \  flt_pt_fix_to_flt
--                                                 RESULT  \ flt_pt_compare
--------------------------------------------------------------------------------

LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;USE IEEE.STD_LOGIC_ARITH.ALL;LIBRARY XILINXCORELIB;USE XILINXCORELIB.
FLOATING_POINT_V4_0_CONSTS.ALL;USE XILINXCORELIB.FLOATING_POINT_PKG_V4_0.ALL;ENTITY FLT_PT_OPERATOR_V4_0 IS GENERIC(C_FAMILY:STRING
:=C_FAMILY_DEFAULT;C_HAS_ADD:INTEGER:=C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:INTEGER:=C_HAS_SUBTRACT_DEFAULT;C_HAS_MULTIPLY:INTEGER:=
C_HAS_MULTIPLY_DEFAULT;C_HAS_DIVIDE:INTEGER:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT:INTEGER:=C_HAS_SQRT_DEFAULT;C_HAS_COMPARE:INTEGER:=
C_HAS_COMPARE_DEFAULT;C_HAS_FIX_TO_FLT:INTEGER:=C_HAS_FIX_TO_FLT_DEFAULT;C_HAS_FLT_TO_FIX:INTEGER:=C_HAS_FLT_TO_FIX_DEFAULT;
C_HAS_FLT_TO_FLT:INTEGER:=C_HAS_FLT_TO_FLT_DEFAULT;C_A_WIDTH:INTEGER:=C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH:INTEGER:=
C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:INTEGER:=C_B_WIDTH_DEFAULT;C_B_FRACTION_WIDTH:INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;
C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;C_RESULT_FRACTION_WIDTH:INTEGER:=C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION
:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY:INTEGER:=C_LATENCY_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;
C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER:=C_RATE_DEFAULT;C_HAS_ACLR:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=
C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;C_HAS_A_NEGATE:INTEGER:=C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=
C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT;C_HAS_A_RFD:INTEGER:=C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=
C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;C_HAS_OPERATION_ND:INTEGER:=C_HAS_OPERATION_ND_DEFAULT;
C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=C_HAS_RDY_DEFAULT;C_HAS_CTS:INTEGER:=C_HAS_CTS_DEFAULT;
C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=C_HAS_OVERFLOW_DEFAULT;C_HAS_INVALID_OP:INTEGER:=
C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;C_HAS_DIVIDE_BY_ZERO:INTEGER:=C_HAS_DIVIDE_BY_ZERO_DEFAULT;
C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=C_HAS_EXCEPTION_DEFAULT;C_STATUS_EARLY:INTEGER:=
C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT);PORT(A:IN STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);B:IN STD_LOGIC_VECTOR(
C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_NEGATE:IN STD_LOGIC:='0';B_NEGATE:IN STD_LOGIC:='0';OPERATION:IN STD_LOGIC_VECTOR(
FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_ND:IN STD_LOGIC:='1';A_RFD:OUT STD_LOGIC;B_ND:IN STD_LOGIC:='1';B_RFD:OUT
 STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';OPERATION_RFD:OUT STD_LOGIC;CLK:IN STD_LOGIC;SCLR:IN STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0'
;CE:IN STD_LOGIC:='1';RESULT:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);STATUS:OUT STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1
 DOWNTO 0);EXCEPTION:OUT STD_LOGIC;UNDERFLOW:OUT STD_LOGIC;OVERFLOW:OUT STD_LOGIC;INVALID_OP:OUT STD_LOGIC;INEXACT:OUT STD_LOGIC;
DIVIDE_BY_ZERO:OUT STD_LOGIC;RDY:OUT STD_LOGIC;CTS:IN STD_LOGIC:='1');END;ARCHITECTURE BEHAVIORAL OF FLT_PT_OPERATOR_V4_0 IS
 PROCEDURE II1IOOO1II0l1lOl00I1O001I00O0IIIII(IO1lll0I0l0l1ll1O01Ol0III011IOIIII:IN INTEGER;IOO0111OO0lOOl10l1l000l0OlI0IIIIII:IN INTEGER;IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII:IN INTEGER;IOOOlI0llOIl11IO01100OI1llOIIOIIII:IN STD_LOGIC;IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII:IN STD_LOGIC_VECTOR;II1001IO0010Oll1I01lOI0I0IlIOIIIII:OUT
 STD_LOGIC_VECTOR;IO110I1O0010OIOlIO00l1IIOl0llIIIII,IIIOOIO01011011IOIIlllIIOO0l1IIIII,II1IOOO00I0OI0O01I000O100llOOIIIII:OUT STD_LOGIC)IS CONSTANT II00OI0110lI1II101lO1OO00I10OIIIII:INTEGER:=IOO0111OO0lOOl10l1l000l0OlI0IIIIII;CONSTANT II00OIlIlO101I0IIOO0O1I0ll0OIIIIII:INTEGER:=IO1lll0I0l0l1ll1O01Ol0III011IOIIII-IOO0111OO0lOOl10l1l000l0OlI0IIIIII;CONSTANT
 IOOI1l1OO01O111lO010OlO1O0l0IIIIII:INTEGER:=2**(II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-1)-1;CONSTANT IO11OllII1lO110Ol0I0O00I01l00IIIII:INTEGER:=2-2**(II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-1);CONSTANT III01lO1l00IOOO0O0I0O0I111O0IIIIII:INTEGER:=2**(II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-1)-1;VARIABLE IO1I1l01l1OI111Ol0IO10110I11IOIIII:
STD_LOGIC_VECTOR(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 0);VARIABLE IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:STD_LOGIC_VECTOR(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-1 DOWNTO 0);VARIABLE IIIOI11O0OO00OllOllO00lOI000IOIIII:STD_LOGIC:='0';VARIABLE IIOIOOO11l0lO001OI10I0IIIIlIIIIIII:
SIGNED(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 0);VARIABLE II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:INTEGER;VARIABLE IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:INTEGER;VARIABLE II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:STD_LOGIC_VECTOR(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 0);VARIABLE IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII
:STD_LOGIC;VARIABLE IO0O10O101OOIOOl10lIIO101lIIIIIIII:INTEGER;VARIABLE IIOl10001I1Ol001OIO01IO1II10OIIIII:SIGNED(II00OI0110lI1II101lO1OO00I10OIIIII+3 DOWNTO 0);BEGIN IIIOI11O0OO00OllOllO00lOI000IOIIII:='0';IIOl10001I1Ol001OIO01IO1II10OIIIII:=(OTHERS=>'0');IO1I1l01l1OI111Ol0IO10110I11IOIIII:=(OTHERS=>'0');IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII
:=CONV_INTEGER(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-1)XOR IOOOlI0llOIl11IO01100OI1llOIIOIIII);IF IIlO1lIIlOlOOO0l10OI1ll0I0O10IIIII=1 THEN IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII:=1-IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII;END IF;IF FLT_PT_IS_NAN(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII)THEN IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:=
FLT_PT_GET_QUIET_NAN(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII);ELSIF FLT_PT_IS_ZERO(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII)THEN IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:=FLT_PT_GET_ZERO(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII,CONV_STD_LOGIC_VECTOR(IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII,1)(
0));ELSIF IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII=1 THEN IIIOI11O0OO00OllOllO00lOI000IOIIII:='1';IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:=FLT_PT_GET_QUIET_NAN(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII);ELSIF FLT_PT_IS_INF(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII,IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII)THEN IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:=
FLT_PT_GET_INF(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII,II00OI0110lI1II101lO1OO00I10OIIIII,CONV_STD_LOGIC_VECTOR(IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII,1)(0));ELSE IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII):='1';IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII-1 DOWNTO 1):=SIGNED(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII(II00OI0110lI1II101lO1OO00I10OIIIII-2 DOWNTO 0));IIOIOOO11l0lO001OI10I0IIIIlIIIIIII
(0):='0';II0IO0I0Olll01OOO0lIOO01lOlIOOIIII:=CONV_INTEGER(UNSIGNED(IO1IOOl1111OI1OOII1IOl0lIIIIOIIIII(II00OI0110lI1II101lO1OO00I10OIIIII+II00OIlIlO101I0IIOO0O1I0ll0OIIIIII-2 DOWNTO II00OI0110lI1II101lO1OO00I10OIIIII-1)));IF IOO10IlOOIIIlOIO1IOI1l1lOIIlOIIIII=1 THEN IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:='1';ELSE IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII:='0';END IF;IO0O10O101OOIOOl10lIIO101lIIIIIIII:=(
II0IO0I0Olll01OOO0lIOO01lOlIOOIIII+IOOI1l1OO01O111lO010OlO1O0l0IIIIII)/2;IF(II0IO0I0Olll01OOO0lIOO01lOlIOOIIII MOD 2=1)THEN IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII-1 DOWNTO 0):=IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 1);IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII):='0';END IF;FOR IIIO0lOII1OIlOOIO1IlI1lIIO001IIIII IN(II00OI0110lI1II101lO1OO00I10OIIIII)DOWNTO 0 LOOP IIOl10001I1Ol001OIO01IO1II10OIIIII
:=IIOl10001I1Ol001OIO01IO1II10OIIIII(II00OI0110lI1II101lO1OO00I10OIIIII+1 DOWNTO 0)&SIGNED(IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO II00OI0110lI1II101lO1OO00I10OIIIII-1));IF IIOl10001I1Ol001OIO01IO1II10OIIIII>=0 THEN IIOl10001I1Ol001OIO01IO1II10OIIIII:=IIOl10001I1Ol001OIO01IO1II10OIIIII-SIGNED(EXT((IO1I1l01l1OI111Ol0IO10110I11IOIIII&"01"),II00OI0110lI1II101lO1OO00I10OIIIII+3));ELSE IIOl10001I1Ol001OIO01IO1II10OIIIII:=IIOl10001I1Ol001OIO01IO1II10OIIIII+SIGNED(EXT((IO1I1l01l1OI111Ol0IO10110I11IOIIII&"11"),II00OI0110lI1II101lO1OO00I10OIIIII+3))
;END IF;IF IIOl10001I1Ol001OIO01IO1II10OIIIII>=0 THEN IO1I1l01l1OI111Ol0IO10110I11IOIIII:=IO1I1l01l1OI111Ol0IO10110I11IOIIII(II00OI0110lI1II101lO1OO00I10OIIIII-1 DOWNTO 0)&'1';ELSE IO1I1l01l1OI111Ol0IO10110I11IOIIII:=IO1I1l01l1OI111Ol0IO10110I11IOIIII(II00OI0110lI1II101lO1OO00I10OIIIII-1 DOWNTO 0)&'0';END IF;IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 0):=IIOIOOO11l0lO001OI10I0IIIIlIIIIIII(II00OI0110lI1II101lO1OO00I10OIIIII-2 DOWNTO 0)&"00";
END LOOP;IF(IO1I1l01l1OI111Ol0IO10110I11IOIIII(0)='1')THEN II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:=UNSIGNED(EXT(IO1I1l01l1OI111Ol0IO10110I11IOIIII(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 1),II00OI0110lI1II101lO1OO00I10OIIIII+1))+1;ELSE II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII:=EXT(IO1I1l01l1OI111Ol0IO10110I11IOIIII(II00OI0110lI1II101lO1OO00I10OIIIII DOWNTO 1),II00OI0110lI1II101lO1OO00I10OIIIII+1);END IF;IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII:=
IO0lIOlI0II1000IOlOIlOI1lIlOOIIIII&CONV_STD_LOGIC_VECTOR(IO0O10O101OOIOOl10lIIO101lIIIIIIII,II00OIlIlO101I0IIOO0O1I0ll0OIIIIII)&II0l0OlOIIIO1I0IOlIIllOIOO10lIIIII(II00OI0110lI1II101lO1OO00I10OIIIII-2 DOWNTO 0);END IF;II1001IO0010Oll1I01lOI0I0IlIOIIIII:=IOOll1I1OOlO0lOO0IIII1lO11IIlIIIII;IO110I1O0010OIOlIO00l1IIOl0llIIIII:=IIIOI11O0OO00OllOllO00lOI000IOIIII;IIIOOIO01011011IOIIlllIIOO0l1IIIII:='0';II1IOOO00I0OI0O01I000O100llOOIIIII
:='0';END;PROCEDURE IIIIl1100lOI0I1OO1I00OlI0l10IIIIII(IOlI00I100IOOOl011O11IOI1l010IIIII:IN INTEGER;IIIO1O1110Oll10OI110OIIO111OOIIIII:IN INTEGER;IIl0OIlO00I0lI101l1I0lO1II0IlIIIII:IN INTEGER;IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII:IN INTEGER;II11I0011I0IIIl0100l1O01O01O0IIIII:IN STD_LOGIC;II011lO0O1l10O0I0OIOO000I0O1IOIIII:IN
 STD_LOGIC;IO1IIIl1OO00II0ll110l0l0IIO0lIIIII:IN STD_LOGIC_VECTOR;IIlOllOOI0ll11O1101IIl0l11ll1IIIII:IN STD_LOGIC_VECTOR;II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:OUT STD_LOGIC_VECTOR;III1OO10l11110IO1IO0lOII0OO11IIIII,IO1O1llOO0IlllI1O1OlOI010l1IIIIIII,IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII,II1IO01lI1IO1OII11O1II01I0llIOIIII:OUT
 STD_LOGIC)IS CONSTANT II1lIII001001Il0l0OOl0I00I01IIIIII:INTEGER:=IIIO1O1110Oll10OI110OIIO111OOIIIII;CONSTANT II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII:INTEGER:=IOlI00I100IOOOl011O11IOI1l010IIIII-IIIO1O1110Oll10OI110OIIO111OOIIIII;CONSTANT IOII100I0I1l010IOI1lO1O1I1101IIIII:INTEGER:=2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1)-1;CONSTANT IOO10OI11Il110I11IIIIIOIO10OlIIIII:INTEGER
:=2-2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1);CONSTANT IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII:INTEGER:=2**(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1)-1;VARIABLE IOl0l10lI11IO10lI1OI1IOI01OO0IIIII,IOO1l1010O10O10I0llO11O100O1IOIIII,IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:STD_LOGIC_VECTOR(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+1 DOWNTO 0);VARIABLE II0IOOI1Il101lO1O010O0O0IO10IOIIII,IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII,
IOOIOOI00l1OOOlI1OOO0I00Ol0IlIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0);VARIABLE II111OIOII1IIOOOlO1I011OI0I0lIIIII,III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:STD_LOGIC;VARIABLE IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII,IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII,IIl1O1I0001l1001OllOOII0I10l1IIIII:BOOLEAN;VARIABLE IIlIlll0III10I0Il0I0OOOIOIIOOIIIII,IOOI10l0O1lIlIll00Ol1lll10IIIIIIII,IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII
:BOOLEAN;CONSTANT IOl0I10010lIIIl000I1O1IO1IlOIIIIII:INTEGER:=2;VARIABLE IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1 DOWNTO 0);VARIABLE IOl1Ol11IlIl0110l0OOll000lI11IIIII,II001Il0III1O1OI001IOI100000OIIIII:STD_LOGIC;
VARIABLE IOOl0llO0OI110111OIOlOIO0lOOIOIIII,II1IOO1l1I11I1ll1OI1I00lII000IIIII:STD_LOGIC;VARIABLE II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1+IOl0I10010lIIIl000I1O1IO1IlOIIIIII+1 DOWNTO 0);VARIABLE IOOl0IOOO1011llOIOl01lIOI0O11IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII-1
 DOWNTO 0);VARIABLE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 0);VARIABLE II1I0O0100lIIII11lI00l0OOII0lIIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 0);VARIABLE IIOIOI0lO1lO100O11Il0OII11OlOIIIII,IO0IlO1lI10Il011101l101IIl0IOIIIII,IOI1O00I10101l0I1001llOOI0I0IOIIII:STD_LOGIC;
VARIABLE IIOIO000I1OI0OlOI1OIOI1l0I0l1IIIII:STD_LOGIC_VECTOR(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 0);VARIABLE IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:STD_LOGIC;VARIABLE IO0l0IOllOl1100O10O1O1l0lIO1OIIIII:STD_LOGIC;BEGIN IOl1Ol11IlIl0110l0OOll000lI11IIIII:='0';
II001Il0III1O1OI001IOI100000OIIIII:='0';IOOl0llO0OI110111OIOlOIO0lOOIOIIII:='0';II1IOO1l1I11I1ll1OI1I00lII000IIIII:='0';II111OIOII1IIOOOlO1I011OI0I0lIIIII:=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-1);IOl0l10lI11IO10lI1OI1IOI01OO0IIIII:=EXT(IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII-1),II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+2);II0IOOI1Il101lO1O010O0O0IO10IOIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0
):=IO1IIIl1OO00II0ll110l0l0IIO0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0);II0IOOI1Il101lO1O010O0O0IO10IOIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1):='1';III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:=IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-1);IOO1l1010O10O10I0llO11O100O1IOIIII:=EXT(IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII-1),II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII+2);IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0):=IIlOllOOI0ll11O1101IIl0l11ll1IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0
);IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1):='1';IF((IIl0OIlO00I0lI101l1I0lO1II0IlIIIII=1)XOR(II11I0011I0IIIl0100l1O01O01O0IIIII='1'))THEN II111OIOII1IIOOOlO1I011OI0I0lIIIII:=NOT II111OIOII1IIOOOlO1I011OI0I0lIIIII;END IF;IF((IOIlII1I0O0l1l1O110O0IOlO0O1lIIIII=1)XOR(II011lO0O1l10O0I0OIOO000I0O1IOIIII='1'))THEN III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII:=NOT III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII;
END IF;IIIIlI10IO0IlIll11O0O1OII0OIIOIIII:=(II111OIOII1IIOOOlO1I011OI0I0lIIIII XOR III0OI0OlIOOl1Ol1I0l00O0lI1IIIIIII);IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII:=FLT_PT_IS_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII:=FLT_PT_IS_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);IIl1O1I0001l1001OllOOII0I10l1IIIII:=FLT_PT_IS_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IO1IIIl1OO00II0ll110l0l0IIO0lIIIII);
IIlIlll0III10I0Il0I0OOOIOIIOOIIIII:=FLT_PT_IS_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IOOI10l0O1lIlIll00Ol1lll10IIIIIIII:=FLT_PT_IS_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII:=FLT_PT_IS_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIlOllOOI0ll11O1101IIl0l11ll1IIIII);IF(IIIlOO0OOl101Ol0Oll10O1lOIIO0IIIII OR IOOI10l0O1lIlIll00Ol1lll10IIIIIIII)THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=
FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);ELSIF IIIO10O1ll1l0O0IOl0l1lllO0lI1IIIII THEN IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);IOl1Ol11IlIl0110l0OOll000lI11IIIII:='1';ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII
:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSE II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);END IF;ELSIF IIl1O1I0001l1001OllOOII0I10l1IIIII THEN IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+
II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_QUIET_NAN(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII);IOl1Ol11IlIl0110l0OOll000lI11IIIII:='1';ELSE II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);END IF;
ELSE IF IIlIlll0III10I0Il0I0OOOIOIIOOIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);ELSIF IO0OOOI1IIIlIOIIOO0Il00I1lOOlIIIII THEN II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);II1IOO1l1I11I1ll1OI1I00lII000IIIII:='1';ELSE IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII
:=SIGNED(IOl0l10lI11IO10lI1OI1IOI01OO0IIIII)-SIGNED(IOO1l1010O10O10I0llO11O100O1IOIIII);IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):=II0IOOI1Il101lO1O010O0O0IO10IOIIII;IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII):=(OTHERS=>'0');II1I0O0100lIIII11lI00l0OOII0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1 DOWNTO 0):=IO1lIIIOl1IIIO1O1lllOO0I1lO0OIIIII;II1I0O0100lIIII11lI00l0OOII0lIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO II1lIII001001Il0l0OOl0I00I01IIIIII
):=(OTHERS=>'0');FOR IIlOO000I01110Ill0l1OI1l10IOIOIIII IN II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 1 LOOP IF IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1)='0'THEN IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)-SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IIlOO000I01110Ill0l1OI1l10IOIOIIII):='1';ELSE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)+
SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IIlOO000I01110Ill0l1OI1l10IOIOIIII):='0';END IF;IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1 DOWNTO 1):=IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII DOWNTO 0);IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(0):='0';END LOOP;IF IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+1)='0'THEN IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)-SIGNED
(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(0):='1';ELSE IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII:=SIGNED(IIOlOO00Ol0011IIIIIO1I1lllIO0IIIII)+SIGNED(II1I0O0100lIIII11lI00l0OOII0lIIIII);II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(0):='0';END IF;II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 0):=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-1+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO 0)&'1';IIOIOI0lO1lO100O11Il0OII11OlOIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII);
IF(IIOIOI0lO1lO100O11Il0OII11OlOIIIII='1')THEN IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IOl0I10010lIIIl000I1O1IO1IlOIIIIII);IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=UNSIGNED(II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII DOWNTO IOl0I10010lIIIl000I1O1IO1IlOIIIIII+1))+IO1Il1I0OOOOIl0IOO011l1I0111OIIIII;ELSE IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:=SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII)-1;IO1Il1I0OOOOIl0IOO011l1I0111OIIIII:=II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(IOl0I10010lIIIl000I1O1IO1IlOIIIIII-1);IOOl0IOOO1011llOIOl01lIOI0O11IIIII:=
UNSIGNED(II0II1IO1I0IOIl0ll1I0O00lIIOOIIIII(II1lIII001001Il0l0OOl0I00I01IIIIII+IOl0I10010lIIIl000I1O1IO1IlOIIIIII-1 DOWNTO IOl0I10010lIIIl000I1O1IO1IlOIIIIII))+IO1Il1I0OOOOIl0IOO011l1I0111OIIIII;END IF;IF CONV_INTEGER(SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII))>IOO1I1lI11Ol1l1OOlllIIII1l1IOIIIII THEN IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=FLT_PT_GET_INF(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);
II001Il0III1O1OI001IOI100000OIIIII:='1';ELSIF CONV_INTEGER(SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII))<IOO10OI11Il110I11IIIIIOIO10OlIIIII THEN IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=FLT_PT_GET_ZERO(II1lIII001001Il0l0OOl0I00I01IIIIII+II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII,II1lIII001001Il0l0OOl0I00I01IIIIII,IIIIlI10IO0IlIll11O0O1OII0OIIOIIII);IOOl0llO0OI110111OIOlOIO0lOOIOIIII:='1';ELSE
 IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII:=SIGNED(IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII)+IOII100I0I1l010IOI1lO1O1I1101IIIII;IOl1I1O0IIO001llOlll1I1lOI1l0IIIII:=IIIIlI10IO0IlIll11O0O1OII0OIIOIIII&IOIlOIOl1lO1l001Ol10IO01OIlI1IIIII(II0O0l0l00OIOl0Ol101Il1Ol0I1lIIIII-1 DOWNTO 0)&IOOl0IOOO1011llOIOl01lIOI0O11IIIII(II1lIII001001Il0l0OOl0I00I01IIIIII-2 DOWNTO 0);END IF;II1I0lOOIIOI1l0l10l0O0l0Ol0OIIIIII:=IOl1I1O0IIO001llOlll1I1lOI1l0IIIII;END IF;END IF;III1OO10l11110IO1IO0lOII0OO11IIIII:=
IOl1Ol11IlIl0110l0OOll000lI11IIIII;II1IO01lI1IO1OII11O1II01I0llIOIIII:=II1IOO1l1I11I1ll1OI1I00lII000IIIII;IO1O1llOO0IlllI1O1OlOI010l1IIIIIII:=II001Il0III1O1OI001IOI100000OIIIII;IO1O0llO0I1lI11I1O10I0l1O0l0IIIIII:=IOOl0llO0OI110111OIOlOIO0lOOIOIIII;END;PROCEDURE II1011O1IO1l0llOI11lIIOIlOlIlIIIII(IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII:IN
 INTEGER;IOI01l1I0000lIO0IIO01IlIO1001IIIII:IN INTEGER;IOI0IIll0I0l1IO0I01lO110IIIIIOIIII:IN INTEGER;IO00l1I0I1IOlII011Il0l0lOI0OIIIIII:IN INTEGER;IO01l1ll0IlOll0I00lll11l0OllIIIIII:IN STD_LOGIC;IOI11IOIlOI1II1Il11OlI01Illl0IIIII:IN STD_LOGIC;IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII:IN STD_LOGIC_VECTOR;IOlIOOI0O1OIlOl01O0OIII10O11lIIIII:IN
 STD_LOGIC_VECTOR;IO1OIOI0I1l11O0IllIOllII1llIIOIIII:OUT STD_LOGIC_VECTOR;IIOOO0OOIll110IlI1111I1001I01IIIII,IO00lII1lIll0OllOlI1l1O0OI100IIIII,IIII1llIll1l01O1l1O0OIlO1l00OIIIII:OUT STD_LOGIC)IS CONSTANT II10ll00IlO1IIOIOIO10II0lI1l0IIIII:INTEGER:=IOI01l1I0000lIO0IIO01IlIO1001IIIII;CONSTANT IOIIOIIO1lIIOOl0IlO11I00II110IIIII:INTEGER
:=IOO0I1l1IOO0II0O00I0IllOOI1OOIIIII-IOI01l1I0000lIO0IIO01IlIO1001IIIII;CONSTANT II0Ol0OI111lIO001O0IIlO110IlIOIIII:INTEGER:=2**(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1)-1;CONSTANT II1ll00lO01110lOI1I0IOO0IlO0IIIIII:INTEGER:=2-2**(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1);CONSTANT IO0I011OOl0OOO000O0I0O0OO0OllIIIII:INTEGER:=2**(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1)-1;
VARIABLE IO1OllI0IIll0OIOI1l01I010OOIOOIIII,IIOl11l1l101llOl0l0l101I1O1llIIIII,III1O0Ol0IOOO0IllIOOO000O1lO0IIIII:STD_LOGIC_VECTOR(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+1 DOWNTO 0);VARIABLE IIl1IIO111llI0l1O1OI00lIl1I0OIIIII,IIIOOI1II1O11lOIOlOIlOOII1010IIIII,IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:STD_LOGIC_VECTOR(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO 0);VARIABLE IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII,IOOI0OO0l1O1O000lO10OOllOIIIIOIIII,IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:STD_LOGIC;
VARIABLE IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:STD_LOGIC_VECTOR(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO 0);VARIABLE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII:STD_LOGIC_VECTOR(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO 0);VARIABLE II10110Oll1OOlIOlOlIl01111IlOIIIII:STD_LOGIC;VARIABLE
 IOIO00lO11l0IOO1l0I101I11l1OOIIIII:STD_LOGIC_VECTOR(II10ll00IlO1IIOIOIO10II0lI1l0IIIII DOWNTO 0);VARIABLE IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII:STD_LOGIC_VECTOR(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+1+II10ll00IlO1IIOIOIO10II0lI1l0IIIII DOWNTO 0):=(OTHERS=>'0');VARIABLE II0l0O0IOlIOI00OIl0IlOlI01OI1IIIII:STD_LOGIC_VECTOR(IOIIOIIO1lIIOOl0IlO11I00II110IIIII
+1+II10ll00IlO1IIOIOIO10II0lI1l0IIIII DOWNTO 0):=(OTHERS=>'1');VARIABLE IIlO0l11I10OOIl000I0OOIO0IO0IIIIII,IIOIOOI1ll1O0I1011l0O1lI0IllIOIIII:STD_LOGIC;VARIABLE IOIlllIIlI1OlI0l101llI0II1O1IOIIII,IOO0IO0OOOOO0I10II0llO10ll1OlIIIII:STD_LOGIC;VARIABLE IIlIII1OIIl0OOl00I0IlOOI1IIlOIIIII,
IOl10OI01O100l1IIIl0IIl1lO10lIIIII:STD_LOGIC;VARIABLE IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII,IO00l1II1l000l0I11O010I1IlOlIOIIII:BOOLEAN;VARIABLE II0IO0O1III0I1I1OlI0011O001IOIIIII,IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:BOOLEAN;VARIABLE IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII,IOl1I001lIl1Il1I11lI00l11O1OOIIIII:BOOLEAN;VARIABLE IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII,III0l0O0I11OOO1lI0OOIO0llOlIlIIIII,IOO01101I01OlOIO111IIl0OOIOI0IIIII:
BOOLEAN;VARIABLE II00l0IOI1lIlOlOOI0I011O1110OIIIII,IOIO1OI0IlI1I1010lO000IO01Ol0IIIII,IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:STD_LOGIC;VARIABLE IIIIOOlIIO11011I1IlOO10OOOO0OIIIII,IIO0101IlI11I0IOlI01l1ll0O10OIIIII:STD_LOGIC;BEGIN IO1OllI0IIll0OIOI1l01I010OOIOOIIII:=EXT(IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1),IOIIOIIO1lIIOOl0IlO11I00II110IIIII+2);IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:=IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII
-1);IIl1IIO111llI0l1O1OI00lIl1I0OIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0):=IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0);IIl1IIO111llI0l1O1OI00lIl1I0OIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1):='1';IIOl11l1l101llOl0l0l101I1O1llIIIII:=EXT(IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1),IOIIOIIO1lIIOOl0IlO11I00II110IIIII+2);IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1);IIIOOI1II1O11lOIOlOIlOOII1010IIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0):=IOlIOOI0O1OIlOl01O0OIII10O11lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2
 DOWNTO 0);IIIOOI1II1O11lOIOlOIlOOII1010IIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1):='1';IF((IOI0IIll0I0l1IO0I01lO110IIIIIOIIII=1)XOR(IO01l1ll0IlOll0I00lll11l0OllIIIIII='1'))THEN IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII:=NOT IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII;END IF;IF((IO00l1I0I1IOlII011Il0l0lOI0OIIIIII=1)XOR(IOI11IOIlOI1II1Il11OlI01Illl0IIIII='1'))THEN IOOI0OO0l1O1O000lO10OOllOIIIIOIIII:=NOT IOOI0OO0l1O1O000lO10OOllOIIIIOIIII;END IF;
IO1IllOO0II1ll1OII0OOO10OO0I1IIIII:=(IIlIOIlO1lO1l1I0OOOI1O1l0O0IOIIIII XOR IOOI0OO0l1O1O000lO10OOllOIIIIOIIII);II0IO0O1III0I1I1OlI0011O001IOIIIII:=FLT_PT_IS_INF(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII);IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII:=FLT_PT_IS_NAN(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII);IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII:=FLT_PT_IS_ZERO(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IIlO0IOl0I0I0lI0OOll1l1l1lO0IIIIII);IIl1OOO111O0O11l1OOllOIIIIIl0IIIII:=
FLT_PT_IS_INF(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IOlIOOI0O1OIlOl01O0OIII10O11lIIIII);IO00l1II1l000l0I11O010I1IlOlIOIIII:=FLT_PT_IS_NAN(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IOlIOOI0O1OIlOl01O0OIII10O11lIIIII);IOl1I001lIl1Il1I11lI00l11O1OOIIIII:=FLT_PT_IS_ZERO(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IOlIOOI0O1OIlOl01O0OIII10O11lIIIII);IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:='0';II00l0IOI1lIlOlOOI0I011O1110OIIIII:='0';IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:='0';IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII
:=FALSE;III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=FALSE;IOO01101I01OlOIO111IIl0OOIOI0IIIII:=FALSE;IF IOI1l0OI1IO0llll1llO11Ol1IIlIIIIII OR IO00l1II1l000l0I11O010I1IlOlIOIIII THEN IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:=TRUE;ELSIF(II0IO0O1III0I1I1OlI0011O001IOIIIII AND IOl1I001lIl1Il1I11lI00l11O1OOIIIII)OR(IIl1OOO111O0O11l1OOllOIIIIIl0IIIII AND IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII)THEN IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII:=TRUE;IIO00Il10lI0OOllOOO0lO11lOOlIOIIII:='1'
;ELSIF II0IO0O1III0I1I1OlI0011O001IOIIIII OR IIl1OOO111O0O11l1OOllOIIIIIl0IIIII THEN III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=TRUE;ELSIF IO00O1llIl1l1I1IIOl11OIlI1lIOOIIII OR IOl1I001lIl1Il1I11lI00l11O1OOIIIII THEN IOO01101I01OlOIO111IIl0OOIOI0IIIII:=TRUE;ELSE III1O0Ol0IOOO0IllIOOO000O1lO0IIIII:=SIGNED(IO1OllI0IIll0OIOI1l01I010OOIOOIIII)+SIGNED(IIOl11l1l101llOl0l0l101I1O1llIIIII)+1-II0Ol0OI111lIO001O0IIlO110IlIOIIII;IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII:=UNSIGNED
(IIl1IIO111llI0l1O1OI00lIl1I0OIIIII)*UNSIGNED(IIIOOI1II1O11lOIOlOIlOOII1010IIIII);IF IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1)='0'THEN IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO 0):=IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0)&'0';III1O0Ol0IOOO0IllIOOO000O1lO0IIIII:=SIGNED(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII)-1;ELSE IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII:=IOOll1I1OO10IlOI0lOO1lOl1O10IOIIII;END IF;IF
(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0)=IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0))THEN II10110Oll1OOlIOlOlIl01111IlOIIIII:='1';ELSE II10110Oll1OOlIOlOlIl01111IlOIIIII:='0';END IF;IF(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1)='1'AND II10110Oll1OOlIOlOlIl01111IlOIIIII='0')OR(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1)='1'AND
 II10110Oll1OOlIOlOlIl01111IlOIIIII='1'AND IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII)='1')THEN IOIO00lO11l0IOO1l0I101I11l1OOIIIII:=UNSIGNED(EXT(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO II10ll00IlO1IIOIOIO10II0lI1l0IIIII),II10ll00IlO1IIOIOIO10II0lI1l0IIIII+1))+1;ELSE IOIO00lO11l0IOO1l0I101I11l1OOIIIII:=EXT(IOOIOOO1OIO1O0OIIOlOOIOlI1l1lIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO II10ll00IlO1IIOIOIO10II0lI1l0IIIII),II10ll00IlO1IIOIOIO10II0lI1l0IIIII+1);END IF
;IF IOIO00lO11l0IOO1l0I101I11l1OOIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII)='1'THEN IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:=IOIO00lO11l0IOO1l0I101I11l1OOIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII DOWNTO 1);III1O0Ol0IOOO0IllIOOO000O1lO0IIIII:=SIGNED(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII)+1;ELSE IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII:=IOIO00lO11l0IOO1l0I101I11l1OOIIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-1 DOWNTO 0);END IF;II00l0IOI1lIlOlOOI0I011O1110OIIIII:='0';IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:='0';IF SIGNED(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII)<=
SIGNED(IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+1 DOWNTO 0))THEN IOO01101I01OlOIO111IIl0OOIOI0IIIII:=TRUE;IOIO1OI0IlI1I1010lO000IO01Ol0IIIII:='1';ELSIF III1O0Ol0IOOO0IllIOOO000O1lO0IIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII+1 DOWNTO IOIIOIIO1lIIOOl0IlO11I00II110IIIII)="01"OR(III1O0Ol0IOOO0IllIOOO000O1lO0IIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1 DOWNTO 0)=NOT IIIIl0I1lO1llIOIOOO1lOl11IIlOIIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1 DOWNTO 0))
THEN III0l0O0I11OOO1lI0OOIO0llOlIlIIIII:=TRUE;II00l0IOI1lIlOlOOI0I011O1110OIIIII:='1';END IF;END IF;IF IOlO1OI10Il1OllOl1IIOOIO0I1lIIIIII THEN IO1OIOI0I1l11O0IllIOllII1llIIOIIII:=FLT_PT_GET_QUIET_NAN(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII);ELSIF III0l0O0I11OOO1lI0OOIO0llOlIlIIIII THEN IO1OIOI0I1l11O0IllIOllII1llIIOIIII:=FLT_PT_GET_INF(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IO1IllOO0II1ll1OII0OOO10OO0I1IIIII
);ELSIF IOO01101I01OlOIO111IIl0OOIOI0IIIII THEN IO1OIOI0I1l11O0IllIOllII1llIIOIIII:=FLT_PT_GET_ZERO(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII,II10ll00IlO1IIOIOIO10II0lI1l0IIIII,IO1IllOO0II1ll1OII0OOO10OO0I1IIIII);ELSE IO1OIOI0I1l11O0IllIOllII1llIIOIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII+IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1 DOWNTO 0):=IO1IllOO0II1ll1OII0OOO10OO0I1IIIII&III1O0Ol0IOOO0IllIOOO000O1lO0IIIII(IOIIOIIO1lIIOOl0IlO11I00II110IIIII-1 DOWNTO 0)&IO0I0I00IO00I1O0I0O0OIOOOI11IOIIII(II10ll00IlO1IIOIOIO10II0lI1l0IIIII-2 DOWNTO 0);END IF;IO00lII1lIll0OllOlI1l1O0OI100IIIII
:=II00l0IOI1lIlOlOOI0I011O1110OIIIII;IIII1llIll1l01O1l1O0OIlO1l00OIIIII:=IOIO1OI0IlI1I1010lO000IO01Ol0IIIII;IIOOO0OOIll110IlI1111I1001I01IIIII:=IIO00Il10lI0OOllOOO0lO11lOOlIOIIII;END;PROCEDURE IOl00OIO0IOOllO1I1O101lIIl11OIIIII(IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII:IN INTEGER;IO00OI0ll1l1l0llI1I000OOO0010IIIII:IN INTEGER;IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII:IN INTEGER;IOI0111Il0IllIIO0O0lO0I111010IIIII:IN
 INTEGER;IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII:IN STD_LOGIC;IOO0llOIlIO0110l1lOO01I00l1OIIIIII:IN STD_LOGIC;IOIO0OOIOIOl0OIllO011O11O0OOIIIIII:IN STD_LOGIC_VECTOR;IO0lI0OlO11O10O1III000O01l0l0IIIII:IN STD_LOGIC_VECTOR;IIO1O00llO01OII1I11lIIO001lI0IIIII:OUT STD_LOGIC_VECTOR;IOIl1lI1IO111IO0OII101O1I0l0IOIIII,IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII
,IO01O100lOO0IOOI000OO1lIOO1l0IIIII:OUT STD_LOGIC)IS CONSTANT IOl1100I00OlIllOI1I0III1O1l01IIIII:INTEGER:=IO00OI0ll1l1l0llI1I000OOO0010IIIII;CONSTANT IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII:INTEGER:=IOl011Ol0O1Il1IIIIlIOlIl101IlIIIII-IO00OI0ll1l1l0llI1I000OOO0010IIIII;CONSTANT IIOIlOO1lI01O10O1Ol0OOI10110OIIIII:INTEGER:=2**(IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1)-1;CONSTANT
 IO0II1lll1llOlO1lll1001O1IlOIOIIII:INTEGER:=2-2**(IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1);CONSTANT IOOO00lOlO0l0llI01lIlOOIIllIlIIIII:INTEGER:=2**(IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1)-1;CONSTANT IIlIIII1lOllO0IlO11I1O01110IOIIIII:SIGNED(IOl1100I00OlIllOI1I0III1O1l01IIIII-1 DOWNTO 0):=(OTHERS=>'0');
CONSTANT II0I1I1l00l1O11OOIOIIllII10IlIIIII:SIGNED(IOl1100I00OlIllOI1I0III1O1l01IIIII DOWNTO 0):='1'&IIlIIII1lOllO0IlO11I1O01110IOIIIII;CONSTANT III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII:SIGNED(IOl1100I00OlIllOI1I0III1O1l01IIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT
 III010I1Ol1OlOI0IO10O0000II11IIIII:SIGNED(IOl1100I00OlIllOI1I0III1O1l01IIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT IOIlOO00I1I00lO00l0I00OlIO01IIIIII:SIGNED(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+3-1 DOWNTO 0):=III0lIIOOIOl0ll0ll0l1lO10IlIIIIIII&'1'&III010I1Ol1OlOI0IO10O0000II11IIIII;CONSTANT
 IIO111Il00001lO0l00lOOlI1IO10IIIII:SIGNED(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+2 DOWNTO 0):=(OTHERS=>'0');VARIABLE II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:STD_LOGIC_VECTOR(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1 DOWNTO 0);VARIABLE IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII,IO0I10OO0llIIlII1I01OOI001IIIIIIII,
II110IlI0l101IO1IlI1O00llI00OIIIII:STD_LOGIC;VARIABLE III0O000IO1IOIO10l0I00lOIII11IIIII:SIGNED(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+2 DOWNTO 0);VARIABLE II1llIOlOlll00O010O1lI1IOI1I1IIIII:SIGNED(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+2 DOWNTO 0);VARIABLE IO1I11OIllI1III1III11OlIIlIIOIIIII:INTEGER;VARIABLE
 IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:INTEGER;VARIABLE IOOI10l11llO01llIIllOI1IO0l1OIIIII:INTEGER;VARIABLE IOO1IIll11IlI110IOlllI1Il1IO1IIIII:INTEGER;VARIABLE IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:INTEGER;VARIABLE IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:SIGNED(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+2 DOWNTO 0);
VARIABLE IIOI10lI0II00O0IOOl0I10001lO1IIIII:STD_LOGIC;VARIABLE IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:INTEGER;VARIABLE IOO01O011lIIIlOl1O0lOIOOI110IOIIII:INTEGER;VARIABLE IOIOO101OO01Ol1101l1O01O1OOllIIIII,IIOO0IIlO0O0I01l00I1011II0011IIIII,IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:BOOLEAN;VARIABLE IIOlI0O00IO011lIIOl100O001lIOOIIII,III0IlIOll1Ill0I0I0OlIO10I1I1IIIII
,IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:BOOLEAN;BEGIN IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII:='0';IO0I10OO0llIIlII1I01OOI001IIIIIIII:='0';II110IlI0l101IO1IlI1O00llI00OIIIII:='0';IOO1IIll11IlI110IOlllI1Il1IO1IIIII:=CONV_INTEGER(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1)XOR IOO0IOIOOll0Il0OlI001lIIIOOOIIIIII);IF IOl0OIIOl0O00OO0lI0I0O1IO1OOIOIIII=1 THEN IOO1IIll11IlI110IOlllI1Il1IO1IIIII
:=1-IOO1IIll11IlI110IOlllI1Il1IO1IIIII;END IF;IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:=CONV_INTEGER(IO0lI0OlO11O10O1III000O01l0l0IIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-1)XOR IOO0llOIlIO0110l1lOO01I00l1OIIIIII);IF IOI0111Il0IllIIO0O0lO0I111010IIIII=1 THEN IOO000O0Ol1OlIOOI00l11I1l1I00IIIII:=1-IOO000O0Ol1OlIOOI00l11I1l1I00IIIII;END IF;IOIOO101OO01Ol1101l1O01O1OOllIIIII:=FLT_PT_IS_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII);
IIOO0IIlO0O0I01l00I1011II0011IIIII:=FLT_PT_IS_NAN(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII);IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII:=FLT_PT_IS_ZERO(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IOIO0OOIOIOl0OIllO011O11O0OOIIIIII);IIOlI0O00IO011lIIOl100O001lIOOIIII:=FLT_PT_IS_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IO0lI0OlO11O10O1III000O01l0l0IIIII);III0IlIOll1Ill0I0I0OlIO10I1I1IIIII:=FLT_PT_IS_NAN(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IO0lI0OlO11O10O1III000O01l0l0IIIII);
IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII:=FLT_PT_IS_ZERO(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IO0lI0OlO11O10O1III000O01l0l0IIIII);IF IIOO0IIlO0O0I01l00I1011II0011IIIII OR III0IlIOll1Ill0I0I0OlIO10I1I1IIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_QUIET_NAN(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII);ELSIF IOIOO101OO01Ol1101l1O01O1OOllIIIII AND IIOlI0O00IO011lIIOl100O001lIOOIIII THEN IF IOO1IIll11IlI110IOlllI1Il1IO1IIIII=
IOO000O0Ol1OlIOOI00l11I1l1I00IIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,CONV_STD_LOGIC_VECTOR(IOO1IIll11IlI110IOlllI1Il1IO1IIIII,1)(0));ELSE II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_QUIET_NAN(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII);IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII
:='1';END IF;ELSIF IOIOO101OO01Ol1101l1O01O1OOllIIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,CONV_STD_LOGIC_VECTOR(IOO1IIll11IlI110IOlllI1Il1IO1IIIII,1)(0));ELSIF IIOlI0O00IO011lIIOl100O001lIOOIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=
FLT_PT_GET_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,CONV_STD_LOGIC_VECTOR(IOO000O0Ol1OlIOOI00l11I1l1I00IIIII,1)(0));ELSIF IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII AND IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII THEN IF(IOO1IIll11IlI110IOlllI1Il1IO1IIIII+IOO000O0Ol1OlIOOI00l11I1l1I00IIIII)=2 THEN IIOI10lI0II00O0IOOl0I10001lO1IIIII:='1';ELSE
 IIOI10lI0II00O0IOOl0I10001lO1IIIII:='0';END IF;II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_ZERO(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IIOI10lI0II00O0IOOl0I10001lO1IIIII);ELSIF IOl0lOIIO0IllIOIO1Oll0lOOOII1IIIII THEN IF IOO000O0Ol1OlIOOI00l11I1l1I00IIIII=1 THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:='1'&IO0lI0OlO11O10O1III000O01l0l0IIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2 DOWNTO 0);ELSE
 II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:='0'&IO0lI0OlO11O10O1III000O01l0l0IIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2 DOWNTO 0);END IF;ELSIF IOOllIl0I1ll0lII0IOIIO1lI10IIIIIII THEN IF IOO1IIll11IlI110IOlllI1Il1IO1IIIII=1 THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:='1'&IOIO0OOIOIOl0OIllO011O11O0OOIIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2 DOWNTO 0);ELSE II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:='0'&IOIO0OOIOIOl0OIllO011O11O0OOIIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2
 DOWNTO 0);END IF;ELSE III0O000IO1IOIO10l0I00lOIII11IIIII:=(OTHERS=>'0');III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII):='1';III0O000IO1IOIO10l0I00lOIII11IIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII-1 DOWNTO IOl1100I00OlIllOI1I0III1O1l01IIIII+1):=SIGNED(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII-2 DOWNTO 0));IO1I11OIllI1III1III11OlIIlIIOIIIII:=CONV_INTEGER
(UNSIGNED(IOIO0OOIOIOl0OIllO011O11O0OOIIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2 DOWNTO IOl1100I00OlIllOI1I0III1O1l01IIIII-1)));IO1I11OIllI1III1III11OlIIlIIOIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII-IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;II1llIOlOlll00O010O1lI1IOI1I1IIIII:=(OTHERS=>'0');II1llIOlOlll00O010O1lI1IOI1I1IIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII):='1';II1llIOlOlll00O010O1lI1IOI1I1IIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII-1 DOWNTO IOl1100I00OlIllOI1I0III1O1l01IIIII+1):=SIGNED(IO0lI0OlO11O10O1III000O01l0l0IIIII
(IOl1100I00OlIllOI1I0III1O1l01IIIII-2 DOWNTO 0));IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:=CONV_INTEGER(UNSIGNED(IO0lI0OlO11O10O1III000O01l0l0IIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII-2 DOWNTO IOl1100I00OlIllOI1I0III1O1l01IIIII-1)));IIl11lIlOO0IIII0IOlI0l1000I1IIIIII:=IIl11lIlOO0IIII0IOlI0l1000I1IIIIII-IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;IF IO1I11OIllI1III1III11OlIIlIIOIIIII>IIl11lIlOO0IIII0IOlI0l1000I1IIIIII THEN IOOI10l11llO01llIIllOI1IO0l1OIIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII-
IIl11lIlOO0IIII0IOlI0l1000I1IIIIII;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IO1I11OIllI1III1III11OlIIlIIOIIIII;II1llIOlOlll00O010O1lI1IOI1I1IIIII:=SHR(II1llIOlOlll00O010O1lI1IOI1I1IIIII,CONV_UNSIGNED(IOOI10l11llO01llIIllOI1IO0l1OIIIII,IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII+1));ELSE IOOI10l11llO01llIIllOI1IO0l1OIIIII:=IIl11lIlOO0IIII0IOlI0l1000I1IIIIII-IO1I11OIllI1III1III11OlIIlIIOIIIII;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IIl11lIlOO0IIII0IOlI0l1000I1IIIIII;III0O000IO1IOIO10l0I00lOIII11IIIII:=SHR(III0O000IO1IOIO10l0I00lOIII11IIIII,
CONV_UNSIGNED(IOOI10l11llO01llIIllOI1IO0l1OIIIII,IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII+1));END IF;IF IOO1IIll11IlI110IOlllI1Il1IO1IIIII=0 THEN IF IOO000O0Ol1OlIOOI00l11I1l1I00IIIII=0 THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=III0O000IO1IOIO10l0I00lOIII11IIIII+II1llIOlOlll00O010O1lI1IOI1I1IIIII;ELSE IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=III0O000IO1IOIO10l0I00lOIII11IIIII-II1llIOlOlll00O010O1lI1IOI1I1IIIII;END IF;ELSE IF
 IOO000O0Ol1OlIOOI00l11I1l1I00IIIII=0 THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=II1llIOlOlll00O010O1lI1IOI1I1IIIII-III0O000IO1IOIO10l0I00lOIII11IIIII;ELSE IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=-(III0O000IO1IOIO10l0I00lOIII11IIIII+II1llIOlOlll00O010O1lI1IOI1I1IIIII);END IF;END IF;IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+2)='1'THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=ABS(IIll0O11l1O1lOl111IIOlOIl0I0OIIIII);
IIOI10lI0II00O0IOOl0I10001lO1IIIII:='1';ELSE IIOI10lI0II00O0IOOl0I10001lO1IIIII:='0';END IF;IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+1)='1'THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=SHR(IIll0O11l1O1lOl111IIOlOIl0I0OIIIII,CONV_UNSIGNED(1,1));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IIO1IIOOO0OO1100OO11l0OOllIIIOIIII+1;ELSE
 IOO01O011lIIIlOl1O0lOIOOI110IOIIII:=0;WHILE IOO01O011lIIIlOl1O0lOIOOI110IOIIII<2*IOl1100I00OlIllOI1I0III1O1l01IIIII AND IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII)='0'LOOP IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=SHL(IIll0O11l1O1lOl111IIOlOIl0I0OIIIII,CONV_UNSIGNED(1,1));IOO01O011lIIIlOl1O0lOIOOI110IOIIII:=IOO01O011lIIIlOl1O0lOIOOI110IOIIII+1;END
 LOOP;IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IIO1IIOOO0OO1100OO11l0OOllIIIOIIII-IOO01O011lIIIlOl1O0lOIOOI110IOIIII;END IF;IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII)='0'THEN ELSIF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII DOWNTO 0)=II0I1I1l00l1O11OOIOIIllII10IlIIIII THEN IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(IOl1100I00OlIllOI1I0III1O1l01IIIII+1)='1'THEN
 IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=IIll0O11l1O1lOl111IIOlOIl0I0OIIIII+IOIlOO00I1I00lO00l0I00OlIO01IIIIII;ELSE END IF;ELSE IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=IIll0O11l1O1lOl111IIOlOIl0I0OIIIII+IOIlOO00I1I00lO00l0I00OlIO01IIIIII;END IF;IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(2*IOl1100I00OlIllOI1I0III1O1l01IIIII+1)='1'THEN IIll0O11l1O1lOl111IIOlOIl0I0OIIIII:=SHR(IIll0O11l1O1lOl111IIOlOIl0I0OIIIII,
CONV_UNSIGNED(1,1));IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IIO1IIOOO0OO1100OO11l0OOllIIIOIIII+1;END IF;IF IIll0O11l1O1lOl111IIOlOIl0I0OIIIII=IIO111Il00001lO0l00lOOlI1IO10IIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_ZERO(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,'0');ELSIF IIO1IIOOO0OO1100OO11l0OOllIIIOIIII<IO0II1lll1llOlO1lll1001O1IlOIOIIII
 THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_ZERO(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IIOI10lI0II00O0IOOl0I10001lO1IIIII);II110IlI0l101IO1IlI1O00llI00OIIIII:='1';ELSIF IIO1IIOOO0OO1100OO11l0OOllIIIOIIII>IOOO00lOlO0l0llI01lIlOOIIllIlIIIII THEN II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=FLT_PT_GET_INF(IOl1100I00OlIllOI1I0III1O1l01IIIII+IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII,IOl1100I00OlIllOI1I0III1O1l01IIIII,IIOI10lI0II00O0IOOl0I10001lO1IIIII
);IO0I10OO0llIIlII1I01OOI001IIIIIIII:='1';ELSE IIO1IIOOO0OO1100OO11l0OOllIIIOIIII:=IIO1IIOOO0OO1100OO11l0OOllIIIOIIII+IIOIlOO1lI01O10O1Ol0OOI10110OIIIII;II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII:=IIOI10lI0II00O0IOOl0I10001lO1IIIII&CONV_STD_LOGIC_VECTOR(IIO1IIOOO0OO1100OO11l0OOllIIIOIIII,IO1OlIO1l10Ill0O11IO0I0ll1OlIIIIII)&CONV_STD_LOGIC_VECTOR(IIll0O11l1O1lOl111IIOlOIl0I0OIIIII(2
*IOl1100I00OlIllOI1I0III1O1l01IIIII-1 DOWNTO IOl1100I00OlIllOI1I0III1O1l01IIIII+1),IOl1100I00OlIllOI1I0III1O1l01IIIII-1);END IF;END IF;IIO1O00llO01OII1I11lIIO001lI0IIIII:=II10IOlI11OOI1IO1OlI0IlI0I0I1IIIII;IOIl1lI1IO111IO0OII101O1I0l0IOIIII:=IO1lO1OOOl00OOI0lOI1Ol1O1lI0IIIIII;IOOIOOOlO000O1I0lOI1OO01l0OOlIIIII:=IO0I10OO0llIIlII1I01OOI001IIIIIIII;IO01O100lOO0IOOI000OO1lIOO1l0IIIII:=II110IlI0l101IO1IlI1O00llI00OIIIII;END;PROCEDURE
 II0I1O11OOll0l0I11O110OlI0lIOOIIII(II1lI1l0l00llI0l0l1O0OOII10I1IIIII:IN INTEGER;II0l10llII1lO0O1lOIlOOI10I0lIIIIII:IN INTEGER;IO1I1OlOI1OII110llI1lI0IIl0O0IIIII:IN INTEGER;II110IO0lllI1lOI110IO00I1lOlIIIIII:IN INTEGER;IIl110lllO10l0llOI11l01I0I1OlIIIII:IN INTEGER;IOOll11IO1O1llOIl10010O1IIOOIIIIII:IN STD_LOGIC;IIII00I101O111lII1O000IO1lOOIIIIII:IN
 STD_LOGIC_VECTOR;IOOI01II11O1I1IOII1II01O1001lIIIII:OUT STD_LOGIC_VECTOR;IO111Il1I1O0lO1OlOI0l01I1O010IIIII,III011IIIl1IO1l0O11000I0llI00IIIII,II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:OUT STD_LOGIC)IS CONSTANT IIO1l1Ol1l11Il0000II00lI011I0IIIII:INTEGER:=II1lI1l0l00llI0l0l1O0OOII10I1IIIII-II0l10llII1lO0O1lOIlOOI10I0lIIIIII;CONSTANT
 IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII:INTEGER:=IO1I1OlOI1OII110llI1lI0IIl0O0IIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII;CONSTANT II1lI11lI1II1000lOllIOl01l0l0IIIII:INTEGER:=2**(IIO1l1Ol1l11Il0000II00lI011I0IIIII-1)-1;CONSTANT II0l0001lI0I0IlllI1I100OO10IIIIIII:INTEGER:=2**(IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII-1)-1;
CONSTANT II01l0llO10l10II111lIlOIllO0lIIIII:INTEGER:=2-2**(IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII-1);CONSTANT IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII:INTEGER:=2**(IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII-1)-1;CONSTANT IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII:UNSIGNED(II0l10llII1lO0O1lOIlOOI10I0lIIIIII
-1 DOWNTO 0):=(OTHERS=>'0');VARIABLE IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:STD_LOGIC;VARIABLE II10l111IOllO0O1111Ill001lll1IIIII:STD_LOGIC;VARIABLE IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:STD_LOGIC;VARIABLE
 IIll1lO0l0lI0OII00l00OO11IlO1IIIII:BOOLEAN;VARIABLE III00O11l11IlIOI1llIIIOII100lIIIII:BOOLEAN;VARIABLE IO1l01O110OIl00l10lOOlI0lI0I0IIIII:BOOLEAN;VARIABLE IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:UNSIGNED(II0l10llII1lO0O1lOIlOOI10I0lIIIIII DOWNTO 0);VARIABLE IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:
INTEGER;VARIABLE IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:STD_LOGIC;VARIABLE III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:BOOLEAN;VARIABLE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:INTEGER;VARIABLE IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:UNSIGNED(II110IO0lllI1lOI110IO00I1lOlIIIIII DOWNTO 0);
VARIABLE III11I01Ol11IOO00IOI1I11OOl10IIIII:BOOLEAN:=FALSE;VARIABLE IIl1lOIllIlIl01ll00O11OIl100IOIIII:STD_LOGIC_VECTOR(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII-1 DOWNTO 0);BEGIN IIl1O01ll1111l0llIOO0OOl1ll0IOIIII:='0';II10l111IOllO0O1111Ill001lll1IIIII:='0';
IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='0';IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=IIII00I101O111lII1O000IO1lOOIIIIII(II1lI1l0l00llI0l0l1O0OOII10I1IIIII-1)XOR IOOll11IO1O1llOIl10010O1IIOOIIIIII;IF IIl110lllO10l0llOI11l01I0I1OlIIIII=1 THEN IIOlIO1l10OOO1l1IlII1ll0100IOIIIII:=NOT IIOlIO1l10OOO1l1IlII1ll0100IOIIIII;END IF;IF II110IO0lllI1lOI110IO00I1lOlIIIIII=II0l10llII1lO0O1lOIlOOI10I0lIIIIII AND IO1I1OlOI1OII110llI1lI0IIl0O0IIIII=II1lI1l0l00llI0l0l1O0OOII10I1IIIII THEN
 IIl1lOIllIlIl01ll00O11OIl100IOIIII:=IIII00I101O111lII1O000IO1lOOIIIIII;ELSE IIll1lO0l0lI0OII00l00OO11IlO1IIIII:=FLT_PT_IS_INF(II1lI1l0l00llI0l0l1O0OOII10I1IIIII,II0l10llII1lO0O1lOIlOOI10I0lIIIIII,IIII00I101O111lII1O000IO1lOOIIIIII);III00O11l11IlIOI1llIIIOII100lIIIII:=FLT_PT_IS_NAN(II1lI1l0l00llI0l0l1O0OOII10I1IIIII,II0l10llII1lO0O1lOIlOOI10I0lIIIIII,IIII00I101O111lII1O000IO1lOOIIIIII);IO1l01O110OIl00l10lOOlI0lI0I0IIIII:=FLT_PT_IS_ZERO(II1lI1l0l00llI0l0l1O0OOII10I1IIIII,II0l10llII1lO0O1lOIlOOI10I0lIIIIII,IIII00I101O111lII1O000IO1lOOIIIIII);IF
 III00O11l11IlIOI1llIIIOII100lIIIII THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=FLT_PT_GET_QUIET_NAN(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII,II110IO0lllI1lOI110IO00I1lOlIIIIII);ELSIF IIll1lO0l0lI0OII00l00OO11IlO1IIIII THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=FLT_PT_GET_INF(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII,II110IO0lllI1lOI110IO00I1lOlIIIIII,
CONV_STD_LOGIC_VECTOR(IIOlIO1l10OOO1l1IlII1ll0100IOIIIII,1)(0));ELSIF IO1l01O110OIl00l10lOOlI0lI0I0IIIII THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=FLT_PT_GET_ZERO(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII,II110IO0lllI1lOI110IO00I1lOlIIIIII,IIOlIO1l10OOO1l1IlII1ll0100IOIIIII);ELSE IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII:=UNSIGNED(
"01"&IIII00I101O111lII1O000IO1lOOIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII-2 DOWNTO 0));IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:=CONV_INTEGER(UNSIGNED(IIII00I101O111lII1O000IO1lOOIIIIII(II1lI1l0l00llI0l0l1O0OOII10I1IIIII-2 DOWNTO II0l10llII1lO0O1lOIlOOI10I0lIIIIII-1)));IOIIOO1001lI01IOOlOllIOOIO1O1IIIII:=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII-II1lI11lI1II1000lOllIOl01l0l0IIIII;IF II0l10llII1lO0O1lOIlOOI10I0lIIIIII<II110IO0lllI1lOI110IO00I1lOlIIIIII THEN IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII
(II110IO0lllI1lOI110IO00I1lOlIIIIII DOWNTO II110IO0lllI1lOI110IO00I1lOlIIIIII-II0l10llII1lO0O1lOIlOOI10I0lIIIIII):=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII DOWNTO 0);IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII(II110IO0lllI1lOI110IO00I1lOlIIIIII-II0l10llII1lO0O1lOIlOOI10I0lIIIIII-1 DOWNTO 0):=(OTHERS=>'0');IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII;ELSE IF
 II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII>1 THEN III11I01Ol11IOO00IOI1I11OOl10IIIII:=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII-2 DOWNTO 0)=IIlI1l00I0IOl1l1O0llllO0I1I0IIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII-2 DOWNTO 0);ELSE III11I01Ol11IOO00IOI1I11OOl10IIIII:=TRUE;END IF;IF
 II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII>0 THEN III1I01Ill1l0lOIlO01lO0I1IlIIOIIII:=(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII-1)='1')AND(NOT(III11I01Ol11IOO00IOI1I11OOl10IIIII)OR(III11I01Ol11IOO00IOI1I11OOl10IIIII AND(IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII)='1')));IF III1I01Ill1l0lOIlO01lO0I1IlIIOIIII THEN
 IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII DOWNTO II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII)+1;ELSE IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII(II0l10llII1lO0O1lOIlOOI10I0lIIIIII DOWNTO II0l10llII1lO0O1lOIlOOI10I0lIIIIII-II110IO0lllI1lOI110IO00I1lOlIIIIII);END IF;IF IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII(II110IO0lllI1lOI110IO00I1lOlIIIIII)='1'
THEN IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII+1;ELSE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII;END IF;ELSE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=IOIIOO1001lI01IOOlOllIOOIO1O1IIIII;IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII:=IIlIO1lIl0lI1lOlI0I0O0I0OO0IIIIIII;END IF;END IF;IF IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII<II01l0llO10l10II111lIlOIllO0lIIIII THEN
 IIl1lOIllIlIl01ll00O11OIl100IOIIII:=FLT_PT_GET_ZERO(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII,II110IO0lllI1lOI110IO00I1lOlIIIIII,IIOlIO1l10OOO1l1IlII1ll0100IOIIIII);IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII:='1';ELSIF IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII>IOl0I1O0OllIl0lI1IlO0OIlII0lIIIIII THEN IIl1lOIllIlIl01ll00O11OIl100IOIIII:=FLT_PT_GET_INF(IO1I1OlOI1OII110llI1lI0IIl0O0IIIII,
II110IO0lllI1lOI110IO00I1lOlIIIIII,IIOlIO1l10OOO1l1IlII1ll0100IOIIIII);II10l111IOllO0O1111Ill001lll1IIIII:='1';ELSE IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII:=IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII+II0l0001lI0I0IlllI1I100OO10IIIIIII;IIl1lOIllIlIl01ll00O11OIl100IOIIII:=IIOlIO1l10OOO1l1IlII1ll0100IOIIIII&CONV_STD_LOGIC_VECTOR(IOOIl1OOO1IIl11O00lI1IlOIIl0OIIIII,IIO1OllIOO1lI1OOO1IOIII1lIl0IOIIII)&
STD_LOGIC_VECTOR(IOlI00ll1I0I1ll0ll01l1OOl0IlIIIIII(II110IO0lllI1lOI110IO00I1lOlIIIIII-2 DOWNTO 0));END IF;END IF;END IF;IOOI01II11O1I1IOII1II01O1001lIIIII:=IIl1lOIllIlIl01ll00O11OIl100IOIIII;IO111Il1I1O0lO1OlOI0l01I1O010IIIII:=IIl1O01ll1111l0llIOO0OOl1ll0IOIIII;III011IIIl1IO1l0O11000I0llI00IIIII:=II10l111IOllO0O1111Ill001lll1IIIII;
II1O1ll0lOO0Ol1O0OO01I0OI0lIIOIIII:=IIlOI1II1OOlOl00Ol01IOl0OO0OOIIIII;END;PROCEDURE IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII:IN INTEGER;IO1OO10IOIO11O10IOOOllllI1Il0IIIII:IN INTEGER;II1IOl1011OlI0O00l1O10OlllOI0IIIII:IN INTEGER;IO1OIOllI1llI01O00IIl0O111IIOOIIII:IN INTEGER;
IO01001lO000lI1lI0IO11lO0I1OlIIIII:IN INTEGER;IOOl11OIOl101I1I1I00lIlIlO00IIIIII:IN STD_LOGIC;IIlOOO01III1O0O0IOII0I0lOlIlOIIIII:IN STD_LOGIC_VECTOR;IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII:IN STD_LOGIC_VECTOR(FLT_PT_ROUND_MODE_WIDTH-1 DOWNTO 0);IIl010l00OlI0lO1OO11Il10lIOIOOIIII:
OUT STD_LOGIC_VECTOR;IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII,IIl111Il0IIlOIO000I01l00l0111IIIII,II1111O0III10O0OOlOlOO1l1I1l0IIIII:OUT STD_LOGIC)IS CONSTANT III00011101l1O1OOI0l0Il0l1l10IIIII:BOOLEAN:=TRUE;CONSTANT IO0lll11llOIOOIOI1lOOIOl000I0IIIII:INTEGER
:=2**(II1011l1lI11IlIlI0l0l00100lO0IIIII-IO1OO10IOIO11O10IOOOllllI1Il0IIIII-1)-1;CONSTANT IO00OO00lIlIO00llOIll10l0ll1OIIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT IIO1lO000Il1O0lOII1IO0OOOIO00IIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO 0):=(OTHERS
=>'1');CONSTANT II1001l0I11O0IIOIl01I1ll0O0OlIIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO 0):='1'&IO00OO00lIlIO00llOIll10l0ll1OIIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII-2 DOWNTO 0);CONSTANT II1II1OO1ll10IlO0I10O0OI000IIOIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII-1
 DOWNTO 0):='0'&IIO1lO000Il1O0lOII1IO0OOOIO00IIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII-2 DOWNTO 0);CONSTANT IOOl01OO110II1I0lIlI001II11I0IIIII:SIGNED(IO1OO10IOIO11O10IOOOllllI1Il0IIIII-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII:SIGNED
(IO1OO10IOIO11O10IOOOllllI1Il0IIIII DOWNTO 0):='1'&IOOl01OO110II1I0lIlI001II11I0IIIII;CONSTANT IIll0I0ll1ll1O0IOlO1O01llII00IIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII DOWNTO 0):=(OTHERS=>'0');CONSTANT II1ll1Il1Il11O10OllIl0l1l1l0IOIIII:SIGNED(IO1OO10IOIO11O10IOOOllllI1Il0IIIII
-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT III0II00l1IIlIO100l00OlI1l1O0IIIII:SIGNED(II1IOl1011OlI0O00l1O10OlllOI0IIIII+IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1 DOWNTO 0):=IIll0I0ll1ll1O0IOlO1O01llII00IIIII&'1'&II1ll1Il1Il11O10OllIl0l1l1l0IOIIII;VARIABLE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:SIGNED
(II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO 0);VARIABLE IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:STD_LOGIC;VARIABLE III101l00lllOOOlIO0OO1lI1OO1OIIIII:STD_LOGIC;VARIABLE II0l0l0II0Il010II1l000011O1lIIIIII:STD_LOGIC;VARIABLE IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:SIGNED(
IO1OO10IOIO11O10IOOOllllI1Il0IIIII+II1IOl1011OlI0O00l1O10OlllOI0IIIII+1 DOWNTO 0);VARIABLE IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:INTEGER;VARIABLE II111O1llOOlI0lOOIIIl0OIlIlllIIIII:INTEGER;VARIABLE IIO11lIl110IO0lO00IOOl0Il11I1IIIII:INTEGER;VARIABLE II1IO0OO0IOlO11110OOlO1O0101IOIIII:INTEGER;VARIABLE
 II0lIlIIOl0I0Ol0lIl0111l1I1l1IIIII:SIGNED(2*IO1OO10IOIO11O10IOOOllllI1Il0IIIII+2 DOWNTO 0);VARIABLE IO0OIl1OO10lO00IlIl0Il0l1l1OIIIIII:STD_LOGIC;VARIABLE IO0lllOII000O01100OOI0II1II01IIIII:INTEGER;CONSTANT IO0IllIIO11IlI1010IIl0l000001IIIII:SIGNED(IO1OO10IOIO11O10IOOOllllI1Il0IIIII-1 DOWNTO 0
):=(OTHERS=>'0');BEGIN IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII:='0';III101l00lllOOOlIO0OO1lI1OO1OIIIII:='0';II0l0l0II0Il010II1l000011O1lIIIIII:='0';II1IO0OO0IOlO11110OOlO1O0101IOIIII:=CONV_INTEGER(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII-1)XOR IOOl11OIOl101I1I1I00lIlIlO00IIIIII);IF IO01001lO000lI1lI0IO11lO0I1OlIIIII=1 THEN II1IO0OO0IOlO11110OOlO1O0101IOIIII
:=1-II1IO0OO0IOlO11110OOlO1O0101IOIIII;END IF;IF FLT_PT_IS_ZERO(II1011l1lI11IlIlI0l0l00100lO0IIIII,IO1OO10IOIO11O10IOOOllllI1Il0IIIII,IIlOOO01III1O0O0IOII0I0lOlIlOIIIII)THEN II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=IO00OO00lIlIO00llOIll10l0ll1OIIIII;ELSIF FLT_PT_IS_NAN(II1011l1lI11IlIlI0l0l00100lO0IIIII,IO1OO10IOIO11O10IOOOllllI1Il0IIIII,IIlOOO01III1O0O0IOII0I0lOlIlOIIIII)THEN II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=II1001l0I11O0IIOIl01I1ll0O0OlIIIII;IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII
:='1';ELSIF FLT_PT_IS_INF(II1011l1lI11IlIlI0l0l00100lO0IIIII,IO1OO10IOIO11O10IOOOllllI1Il0IIIII,IIlOOO01III1O0O0IOII0I0lOlIlOIIIII)THEN IF II1IO0OO0IOlO11110OOlO1O0101IOIIII=0 THEN II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=II1II1OO1ll10IlO0I10O0OI000IIOIIII;ELSE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=II1001l0I11O0IIOIl01I1ll0O0OlIIIII;END IF;III101l00lllOOOlIO0OO1lI1OO1OIIIII:='1';IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII
:='1';ELSE IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=(OTHERS=>'0');IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII+II1IOl1011OlI0O00l1O10OlllOI0IIIII):='1';IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII+II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO II1IOl1011OlI0O00l1O10OlllOI0IIIII+1):=SIGNED(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII-2 DOWNTO 0));IOO0lOOOll1OI0OI0lI10IOOOII00IIIII
:=CONV_INTEGER(UNSIGNED(IIlOOO01III1O0O0IOII0I0lOlIlOIIIII(II1011l1lI11IlIlI0l0l00100lO0IIIII-2 DOWNTO IO1OO10IOIO11O10IOOOllllI1Il0IIIII-1)));IOO0lOOOll1OI0OI0lI10IOOOII00IIIII:=IOO0lOOOll1OI0OI0lI10IOOOII00IIIII-IO0lll11llOIOOIOI1lOOIOl000I0IIIII;IIO11lIl110IO0lO00IOOl0Il11I1IIIII:=(II1IOl1011OlI0O00l1O10OlllOI0IIIII-(IO1OIOllI1llI01O00IIl0O111IIOOIIII+1))-IOO0lOOOll1OI0OI0lI10IOOOII00IIIII;IF IIO11lIl110IO0lO00IOOl0Il11I1IIIII>0 OR(
IIO11lIl110IO0lO00IOOl0Il11I1IIIII=0 AND IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII+II1IOl1011OlI0O00l1O10OlllOI0IIIII-1 DOWNTO IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1)=IO0IllIIO11IlI1010IIl0l000001IIIII)THEN IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=SHR(IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII,CONV_UNSIGNED(IIO11lIl110IO0lO00IOOl0Il11I1IIIII,II1011l1lI11IlIlI0l0l00100lO0IIIII-IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1));ELSE
 III101l00lllOOOlIO0OO1lI1OO1OIIIII:='1';END IF;IF IIO11lIl110IO0lO00IOOl0Il11I1IIIII>II1IOl1011OlI0O00l1O10OlllOI0IIIII THEN II0l0l0II0Il010II1l000011O1lIIIIII:='1';END IF;IF IIIl1IO0lOOOIIlOOllOl010IOl1IOIIII=FLT_PT_RND_TO_NEAREST_EVEN THEN IF(IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII)=
'0')THEN ELSIF IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII DOWNTO 0)=II0IIlIOII0IIl1lIO1llO1O1lOlIIIIII THEN IF(IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1)='1')THEN IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII+III0II00l1IIlIO100l00OlI1l1O0IIIII;ELSE END IF;ELSE IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII:=IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII+
III0II00l1IIlIO100l00OlI1l1O0IIIII;END IF;END IF;IF II1IO0OO0IOlO11110OOlO1O0101IOIIII=1 THEN IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII+IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1 DOWNTO IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1):=-IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII+IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1 DOWNTO IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1);END IF;IF(IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(
IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1+II1IOl1011OlI0O00l1O10OlllOI0IIIII)XOR IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(IO1OO10IOIO11O10IOOOllllI1Il0IIIII+II1IOl1011OlI0O00l1O10OlllOI0IIIII))='1'THEN III101l00lllOOOlIO0OO1lI1OO1OIIIII:='1';END IF;IF IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII='1'OR III101l00lllOOOlIO0OO1lI1OO1OIIIII='1'THEN IF II1IO0OO0IOlO11110OOlO1O0101IOIIII=0 THEN II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=
II1II1OO1ll10IlO0I10O0OI000IIOIIII;ELSE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=II1001l0I11O0IIOIl01I1ll0O0OlIIIII;END IF;ELSE II11OIIIO0I0OI0IIIIO1lOO011IlIIIII:=IIlIIOOI1lOO0O0I1O1O10lI0OlIOOIIII(II1IOl1011OlI0O00l1O10OlllOI0IIIII+IO1OO10IOIO11O10IOOOllllI1Il0IIIII DOWNTO IO1OO10IOIO11O10IOOOllllI1Il0IIIII+1);END IF;END IF;IIl010l00OlI0lO1OO11Il10lIOIOOIIII:=STD_LOGIC_VECTOR(II11OIIIO0I0OI0IIIIO1lOO011IlIIIII);
IF NOT(III00011101l1O1OOI0l0Il0l1l10IIIII)THEN IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII OR III101l00lllOOOlIO0OO1lI1OO1OIIIII;IIl111Il0IIlOIO000I01l00l0111IIIII:='0';II1111O0III10O0OOlOlOO1l1I1l0IIIII:='0';ELSE IIOIl1I10OOOllIlIOl11lI0IO1lIOIIII:=IOl0lI0l0O1IlOIlI1IlO1l01Il00IIIII;IIl111Il0IIlOIO000I01l00l0111IIIII:=
III101l00lllOOOlIO0OO1lI1OO1OIIIII;II1111O0III10O0OOlOlOO1l1I1l0IIIII:='0';END IF;END;PROCEDURE II1l0I0l10l0I1I1lO01l10I01lI1IIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII:IN INTEGER;IIOI1lO0I00III00II0IO0ll0111IOIIII:IN INTEGER;III11OII1IlIl1001I1IO1111l0IlIIIII:IN INTEGER;IIII11lI1lOl0OlOO0II11lI101lOIIIII:IN
 INTEGER;IOl0Ill1OOl0O1IO1l0010I0lO010IIIII:IN INTEGER;IO0IlOI1OIOO0l101l10IO00l0101IIIII:IN STD_LOGIC;IIOO1OlIO01I00l0OO0I11OII1OlOIIIII:IN STD_LOGIC_VECTOR;IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:OUT STD_LOGIC_VECTOR;IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII,IIl1O1IllII0I01IlO01l0lII0lIOOIIII,IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:OUT
 STD_LOGIC)IS FUNCTION IIII00IOl0llO0O011llO1lOOOIIOIIIII(IIlOIl110lOl10lO1OIllII10IOO1IIIII,IO0O00IOlOOIOO11lI01l000IIIIOIIIII:INTEGER)RETURN INTEGER IS VARIABLE II10I1011llOIIlI00OI0IIIl0OIOIIIII:INTEGER:=IIlOIl110lOl10lO1OIllII10IOO1IIIII;BEGIN IF IO0O00IOlOOIOO11lI01l000IIIIOIIIII>IIlOIl110lOl10lO1OIllII10IOO1IIIII THEN II10I1011llOIIlI00OI0IIIl0OIOIIIII:=IO0O00IOlOOIOO11lI01l000IIIIOIIIII;END IF;RETURN(
II10I1011llOIIlI00OI0IIIl0OIOIIIII);END;CONSTANT IOI0O1l0101lI100OIOIlll001OO1IIIII:INTEGER:=III11OII1IlIl1001I1IO1111l0IlIIIII-IIII11lI1lOl0OlOO0II11lI101lOIIIII;CONSTANT IIlI1lIIIOI0l01l01OOII00I0O0lIIIII:INTEGER:=2**(IOI0O1l0101lI100OIOIlll001OO1IIIII-1)-1;CONSTANT IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII:INTEGER:=0;CONSTANT
 IIl000O0IO0llO0II1lI1010lOO0IOIIII:INTEGER:=2**IOI0O1l0101lI100OIOIlll001OO1IIIII-1;CONSTANT IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII:INTEGER:=IIII00IOl0llO0O011llO1lOOOIIOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII+1,IIII11lI1lOl0OlOO0II11lI101lOIIIII+1);CONSTANT IOlIll0lIIOlIl1l1lI01OII11lOIIIIII:SIGNED(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1 DOWNTO 0):=(OTHERS=>
'0');VARIABLE II1OO01O01O10l0IIOIII101O1000IIIII:INTEGER;VARIABLE II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:SIGNED(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1 DOWNTO 0);VARIABLE II0I00l0IOOO11I1l0O11O1I1O101IIIII:STD_LOGIC_VECTOR(III11OII1IlIl1001I1IO1111l0IlIIIII-1 DOWNTO 0);
VARIABLE IOlO0lIIlI010OIO10l11l1l1lIO0IIIII,II10010II0ll0l10O0OOI01I11110IIIII,IIllIl0lIO10011Ol0O10l01O1Il0IIIII:STD_LOGIC;VARIABLE III0lIIl1lO0OI1OlO101lI10lIIIOIIII:SIGNED(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1 DOWNTO 0);VARIABLE IIO01II0O1OlI01l11l10Il10llI0IIIII:INTEGER;VARIABLE IIII10l0Ol001IlOlO1OO1l1llO00IIIII:
INTEGER;VARIABLE IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:STD_LOGIC;VARIABLE II0lIllO11Ill0l10OIOI01I00I1OIIIII:INTEGER;VARIABLE IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:INTEGER;VARIABLE IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:BOOLEAN;BEGIN IOlO0lIIlI010OIO10l11l1l1lIO0IIIII:='0';
II10010II0ll0l10O0OOI01I11110IIIII:='0';IIllIl0lIO10011Ol0O10l01O1Il0IIIII:='0';IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII:=IIOO1OlIO01I00l0OO0I11OII1OlOIIIII(IIO001lIl0II1lI10I1000O00Ol10IIIII-1)XOR IO0IlOI1OIOO0l101l10IO00l0101IIIII;III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=(OTHERS=>'0');III0lIIl1lO0OI1OlO101lI10lIIIOIIII(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1 DOWNTO IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-IIO001lIl0II1lI10I1000O00Ol10IIIII-1):=SIGNED(SXT(IIOO1OlIO01I00l0OO0I11OII1OlOIIIII,IIO001lIl0II1lI10I1000O00Ol10IIIII+1))
;IF IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII>(IIO001lIl0II1lI10I1000O00Ol10IIIII+1)THEN III0lIIl1lO0OI1OlO101lI10lIIIOIIII(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-IIO001lIl0II1lI10I1000O00Ol10IIIII-2 DOWNTO 0):=(OTHERS=>'0');END IF;IIO01II0O1OlI01l11l10Il10llI0IIIII:=(IIO001lIl0II1lI10I1000O00Ol10IIIII-IIOI1lO0I00III00II0IO0ll0111IOIIII)-1+IIlI1lIIIOI0l01l01OOII00I0O0lIIIII;IF IOl0Ill1OOl0O1IO1l0010I0lO010IIIII=1 THEN IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII
:=NOT IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII;END IF;IF IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII='1'THEN III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=-III0lIIl1lO0OI1OlO101lI10lIIIOIIII;END IF;IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=0;WHILE IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII<IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII AND III0lIIl1lO0OI1OlO101lI10lIIIOIIII(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-2)='0'LOOP III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=
SHL(III0lIIl1lO0OI1OlO101lI10lIIIOIIII,CONV_UNSIGNED(1,1));IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII:=IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII+1;END LOOP;IIO01II0O1OlI01l11l10Il10llI0IIIII:=IIO01II0O1OlI01l11l10Il10llI0IIIII-IOO11lOOlO1lO1OOIIIOOl0l00OOIOIIII;II1OO01O01O10l0IIOIII101O1000IIIII:=IIO001lIl0II1lI10I1000O00Ol10IIIII-IIII11lI1lOl0OlOO0II11lI101lOIIIII;IF(II1OO01O01O10l0IIOIII101O1000IIIII>0)THEN
 II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII:=(OTHERS=>'0');II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII(II1OO01O01O10l0IIOIII101O1000IIIII-1):='1';IF III0lIIl1lO0OI1OlO101lI10lIIIOIIII(II1OO01O01O10l0IIOIII101O1000IIIII-1)='0'THEN ELSE IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:=TRUE;IF II1OO01O01O10l0IIOIII101O1000IIIII>1 THEN FOR II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII IN 0 TO II1OO01O01O10l0IIOIII101O1000IIIII
-2 LOOP IF III0lIIl1lO0OI1OlO101lI10lIIIOIIII(II1I01lOI10OOOlO0lO1O0OOIOlI0IIIII)='1'THEN IOI1I0l0OllIO01I0O1O001I0lI1IOIIII:=FALSE;END IF;END LOOP;END IF;IF IOI1I0l0OllIO01I0O1O001I0lI1IOIIII THEN IF III0lIIl1lO0OI1OlO101lI10lIIIOIIII(II1OO01O01O10l0IIOIII101O1000IIIII)='1'THEN III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=III0lIIl1lO0OI1OlO101lI10lIIIOIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII;END IF;
ELSE III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=III0lIIl1lO0OI1OlO101lI10lIIIOIIII+II1l10I1lIlOIIl1lO0IO0I1OOIIlIIIII;END IF;END IF;IF(III0lIIl1lO0OI1OlO101lI10lIIIOIIII(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1))='1'THEN III0lIIl1lO0OI1OlO101lI10lIIIOIIII:=SHR(III0lIIl1lO0OI1OlO101lI10lIIIOIIII,CONV_UNSIGNED(1,1));IIO01II0O1OlI01l11l10Il10llI0IIIII:=IIO01II0O1OlI01l11l10Il10llI0IIIII+1;END IF;END
 IF;IF III0lIIl1lO0OI1OlO101lI10lIIIOIIII=IOlIll0lIIOlIl1l1lI01OII11lOIIIIII THEN II0I00l0IOOO11I1l0O11O1I1O101IIIII:=FLT_PT_GET_ZERO(III11OII1IlIl1001I1IO1111l0IlIIIII,IIII11lI1lOl0OlOO0II11lI101lOIIIII,'0');ELSIF IIO01II0O1OlI01l11l10Il10llI0IIIII<IO1lII1OIl0llIl0IIlIlOI10l0OlIIIII THEN II0I00l0IOOO11I1l0O11O1I1O101IIIII:=FLT_PT_GET_ZERO(
III11OII1IlIl1001I1IO1111l0IlIIIII,IIII11lI1lOl0OlOO0II11lI101lOIIIII,IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII);ELSIF IIO01II0O1OlI01l11l10Il10llI0IIIII>IIl000O0IO0llO0II1lI1010lOO0IOIIII THEN II0I00l0IOOO11I1l0O11O1I1O101IIIII:=FLT_PT_GET_INF(III11OII1IlIl1001I1IO1111l0IlIIIII,IIII11lI1lOl0OlOO0II11lI101lOIIIII,IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII);ELSE IIO01II0O1OlI01l11l10Il10llI0IIIII:=IIO01II0O1OlI01l11l10Il10llI0IIIII;II0I00l0IOOO11I1l0O11O1I1O101IIIII:=
IO11OI1l0l1I1IOl1Ol0lIlIlOlO1IIIII&CONV_STD_LOGIC_VECTOR(IIO01II0O1OlI01l11l10Il10llI0IIIII,III11OII1IlIl1001I1IO1111l0IlIIIII-IIII11lI1lOl0OlOO0II11lI101lOIIIII)&STD_LOGIC_VECTOR(STD_LOGIC_VECTOR(III0lIIl1lO0OI1OlO101lI10lIIIOIIII(IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-3 DOWNTO IOlO1l1O00OIII1I0l0lOll0IOlO0IIIII-1-IIII11lI1lOl0OlOO0II11lI101lOIIIII)));
END IF;IIOOI1O1lllllI10ll0I0OIO1IIlIIIIII:=II0I00l0IOOO11I1l0O11O1I1O101IIIII;IIIIOI0l0OOO1O1ll0OOI00lI0l1IOIIII:=IOlO0lIIlI010OIO10l11l1l1lIO0IIIII;IIl1O1IllII0I01IlO01l0lII0lIOOIIII:=II10010II0ll0l10O0OOI01I11110IIIII;IOI1IOl0OI0O1OllO10lO1lOOl0l1IIIII:=IIllIl0lIO10011Ol0O10l01O1Il0IIIII;END;PROCEDURE IIIO01IOl00Il00111I010ll11010IIIII(IO000l1I110IOlI1l1OlO00l1011IIIIII:IN INTEGER;II1l1I00I1OI1Il0l111OOI10l1lIOIIII:IN
 INTEGER;II01Il0I0I011lOlIO11Il1l11IOlIIIII:IN INTEGER;IO1O0O0O00O0I0100lIl10OOIlO0OIIIII:IN INTEGER;IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII:IN INTEGER;IIl111OlOO0lll00IOO01OOIl1l1IIIIII:IN STD_LOGIC;IIO101OI0lOlOI1IIOllllI10O1lIIIIII:IN STD_LOGIC;IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII:IN
 STD_LOGIC_VECTOR(FLT_PT_COMPARE_OPERATION_WIDTH-1 DOWNTO 0);II00lO01O111Ol1OOIllOOl110OOIIIIII:IN STD_LOGIC_VECTOR;IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII:IN STD_LOGIC_VECTOR;III110I0l00l0lOl000OOI0I1IOlIOIIII:OUT STD_LOGIC_VECTOR;
IIOI0III1IIlI00OOOI1I100OOIIOOIIII:OUT STD_LOGIC)IS CONSTANT IIIIOO0llOIll1IO0lIlO0l111O0IOIIII:INTEGER:=II1l1I00I1OI1Il0l111OOI10l1lIOIIII;CONSTANT IO0O1OIIlI0I0101llOI1O01OOIIOOIIII:INTEGER:=IO000l1I110IOlI1l1OlO00l1011IIIIII-II1l1I00I1OI1Il0l111OOI10l1lIOIIII;CONSTANT IOOOOI1lIlOlI10IOOOI00O10O00IIIIII:INTEGER:=2**(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII-1)-1;
CONSTANT II1O1lIOOI00OOI10010I1010IOOOIIIII:INTEGER:=2-2**(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII-1);CONSTANT IOO0IlOlIOOll110I1l0O0011lllIOIIII:INTEGER:=2**(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII-1)-1;VARIABLE IOOl1IIO0I01ll0O00O01O1I000IOIIIII:UNSIGNED(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO 0);VARIABLE
 IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII:UNSIGNED(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO 0);VARIABLE III1lI0IOlOO11l0lO0IIl00OlOl0IIIII:UNSIGNED(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII-1 DOWNTO 0);VARIABLE IIO1lIlIlIIll0011II00OlO00llOIIIII:UNSIGNED(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII-1 DOWNTO 0);VARIABLE IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII:
STD_LOGIC;VARIABLE IIOl00111100II1IOl0O1OO1I0lIOOIIII:STD_LOGIC;VARIABLE II101I1OIIl111101l00ll0Ol1l01IIIII:BOOLEAN;VARIABLE IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:BOOLEAN;VARIABLE IOI111lOI111OOlI0III1I0lO1I0IIIIII:BOOLEAN;VARIABLE IOl0l0l0I0I0l0I010011l0llIl1lIIIII:BOOLEAN;
VARIABLE IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII:STD_LOGIC_VECTOR(3 DOWNTO 0);VARIABLE II001lI100O0O0I1l1IIOlIlO00IlIIIII:BOOLEAN;VARIABLE IO1Ol0OlIIO11llOOl00IIIO11101IIIII:BOOLEAN;VARIABLE IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:
STD_LOGIC;VARIABLE II0O01100OIIIl10O1OIl0I00Ol10IIIII,II1I1IOl0I0I1I0lIl00ll11I111OIIIII,IO0O010II00IOl10I10O1l0I10O1IOIIII:BOOLEAN;VARIABLE II11OlI0I00OIO1llOI00O0lI0OlIIIIII,IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII,IOOlII11IOO011lOll1IOO10O010OIIIII:BOOLEAN;BEGIN IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII:=II00lO01O111Ol1OOIllOOl110OOIIIIII(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII+IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-1);III1lI0IOlOO11l0lO0IIl00OlOl0IIIII:=UNSIGNED(II00lO01O111Ol1OOIllOOl110OOIIIIII(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII+IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO
 IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-1));IOOl1IIO0I01ll0O00O01O1I000IOIIIII(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO 0):=UNSIGNED(II00lO01O111Ol1OOIllOOl110OOIIIIII(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO 0));IIOl00111100II1IOl0O1OO1I0lIOOIIII:=IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII+IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-1);IIO1lIlIlIIll0011II00OlO00llOIIIII:=UNSIGNED(IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(IO0O1OIIlI0I0101llOI1O01OOIIOOIIII+IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-1));IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO
 0):=UNSIGNED(IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII-2 DOWNTO 0));IF((IO1O0O0O00O0I0100lIl10OOIlO0OIIIII=1)XOR(IIl111OlOO0lll00IOO01OOIl1l1IIIIII='1'))THEN IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII:=NOT IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII;END IF;IF((IIlOlIIOllO0I11I1OlOIlIl1IlOOIIIII=1)XOR(IIO101OI0lOlOI1IIOllllI10O1lIIIIII='1'))THEN IIOl00111100II1IOl0O1OO1I0lIOOIIII
:=NOT IIOl00111100II1IOl0O1OO1I0lIOOIIII;END IF;II0O01100OIIIl10O1OIl0I00Ol10IIIII:=FLT_PT_IS_INF(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,II00lO01O111Ol1OOIllOOl110OOIIIIII);II1I1IOl0I0I1I0lIl00ll11I111OIIIII:=FLT_PT_IS_NAN(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,II00lO01O111Ol1OOIllOOl110OOIIIIII);IO0O010II00IOl10I10O1l0I10O1IOIIII:=FLT_PT_IS_ZERO(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,II00lO01O111Ol1OOIllOOl110OOIIIIII);II11OlI0I00OIO1llOI00O0lI0OlIIIIII:=
FLT_PT_IS_INF(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII);IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII:=FLT_PT_IS_NAN(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII);IOOlII11IOO011lOll1IOO10O010OIIIII:=FLT_PT_IS_ZERO(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII);II101I1OIIl111101l00ll0Ol1l01IIIII:=FALSE;IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=FALSE;IOI111lOI111OOlI0III1I0lO1I0IIIIII:=
FALSE;IOl0l0l0I0I0l0I010011l0llIl1lIIIII:=FALSE;IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:='0';IF(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='0'AND IIOl00111100II1IOl0O1OO1I0lIOOIIII='1')THEN IOI111lOI111OOlI0III1I0lO1I0IIIIII:=TRUE;ELSIF(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='1'AND IIOl00111100II1IOl0O1OO1I0lIOOIIII='0')THEN IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=TRUE;ELSIF
(III1lI0IOlOO11l0lO0IIl00OlOl0IIIII/=IIO1lIlIlIIll0011II00OlO00llOIIIII)THEN IF(IIO1lIlIlIIll0011II00OlO00llOIIIII>III1lI0IOlOO11l0lO0IIl00OlOl0IIIII)THEN IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='0');IOI111lOI111OOlI0III1I0lO1I0IIIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='1');ELSE IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='1');IOI111lOI111OOlI0III1I0lO1I0IIIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='0');END IF;
ELSE IF(IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII>IOOl1IIO0I01ll0O00O01O1I000IOIIIII)THEN IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='0');IOI111lOI111OOlI0III1I0lO1I0IIIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='1');ELSE IF(IOO00I1Ill00Oll1OOOO01IlIlOlIIIIII/=IOOl1IIO0I01ll0O00O01O1I000IOIIIII)THEN IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='1');IOI111lOI111OOlI0III1I0lO1I0IIIIII:=(IOIII0l1O1IIOII0OI00lIOOI0IlOIIIII='0');
ELSE II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;END IF;END IF;END IF;IF IO0O010II00IOl10I10O1l0I10O1IOIIII AND IOOlII11IOO011lOll1IOO10O010OIIIII THEN II101I1OIIl111101l00ll0Ol1l01IIIII:=TRUE;IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=FALSE;IOI111lOI111OOlI0III1I0lO1I0IIIIII:=FALSE;END IF;IF II1I1IOl0I0I1I0lIl00ll11I111OIIIII OR IO1I1OO00O1lIOOIll0lIO0l10lIlIIIII THEN
 II101I1OIIl111101l00ll0Ol1l01IIIII:=FALSE;IO1ll0OlO000O0lIO01I1llIOlOI1IIIII:=FALSE;IOI111lOI111OOlI0III1I0lO1I0IIIIII:=FALSE;IOl0l0l0I0I0l0I010011l0llIl1lIIIII:=TRUE;END IF;IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII:=(OTHERS=>'0');IF IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="111"THEN IF II101I1OIIl111101l00ll0Ol1l01IIIII THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(0):=
'1';END IF;IF IO1ll0OlO000O0lIO01I1llIOlOI1IIIII THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(1):='1';END IF;IF IOI111lOI111OOlI0III1I0lO1I0IIIIII THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(2):='1';END IF;IF IOl0l0l0I0I0l0I010011l0llIl1lIIIII THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(3):='1';END IF;ELSIF((
IOI111lOI111OOlI0III1I0lO1I0IIIIII AND(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII(2)='1'))OR(II101I1OIIl111101l00ll0Ol1l01IIIII AND(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII(1)='1'))OR(IO1ll0OlO000O0lIO01I1llIOlOI1IIIII AND(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII(0)='1')))THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(0):='1';ELSIF(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="000")THEN IF
(IOl0l0l0I0I0l0I010011l0llIl1lIIIII)THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(0):='1';END IF;END IF;IF(FLT_PT_IS_DENORMALIZED(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,II00lO01O111Ol1OOIllOOl110OOIIIIII)OR FLT_PT_IS_DENORMALIZED(IIIIOO0llOIll1IO0lIlO0l111O0IOIIII+IO0O1OIIlI0I0101llOI1O01OOIIOOIIII,IIIIOO0llOIll1IO0lIlO0l111O0IOIIII,IIO00IlOO0lO0l1OO0l00lOOI0lO0IIIII))THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII:=(
OTHERS=>'0');IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:='1';ELSE IF(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII/="111"AND((IOl0l0l0I0I0l0I010011l0llIl1lIIIII AND NOT(IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="000"OR IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="010"OR IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="101"))))THEN IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII:=
'1';IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(0):='0';END IF;END IF;IF(IOl0l0l0I0I0l0I010011l0llIl1lIIIII AND IIOO0lIlIOlI0Ol010ll0lIl100IIIIIII="101")THEN IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(0):='1';END IF;IF II01Il0I0I011lOlIO11Il1l11IOlIIIII>4 THEN III110I0l00l0lOl000OOI0I1IOlIOIIII(3 DOWNTO 0):=IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII;FOR
 IOI1IlOO001111I101I1O01l01lI1IIIII IN 4 TO II01Il0I0I011lOlIO11Il1l11IOlIIIII-1 LOOP III110I0l00l0lOl000OOI0I1IOlIOIIII(IOI1IlOO001111I101I1O01l01lI1IIIII):='0';END LOOP;ELSE III110I0l00l0lOl000OOI0I1IOlIOIIII:=IO1l0OlOOl00O1OIlI0O0lIIlIlOlIIIII(II01Il0I0I011lOlIO11Il1l11IOlIIIII-1 DOWNTO 0);END IF;IIOI0III1IIlI00OOOI1I100OOIIOOIIII:=IOl0I1IOO010I0II10OOIl1ll1Ol1IIIII;END;SIGNAL II1l0l1O010I00O1Ill1O10lIII0OIIIII:
INTEGER:=2;TYPE IO0Oll001000I1I0IIOO101lI10lIIIIII IS ARRAY(NATURAL RANGE<>)OF STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);TYPE IOI0IlOIlO11lO1OO1ll111101lO1IIIII IS ARRAY(NATURAL RANGE<>)OF
 STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0);TYPE IIIlO001lO010I00O0OOllOO00l01IIIII IS ARRAY(NATURAL RANGE<>)OF STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0);
SIGNAL IOlII0O0Oll1OO0O1O0O0O111O00lIIIII:STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');SIGNAL IOO1ll00l01O0lI100l10I1OOl0IIOIIII:STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0'
);SIGNAL IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII:STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');CONSTANT IOI111OlI111O1lI0lO1I00O0II10IIIII:INTEGER:=100;
SIGNAL IIOI01II0OIl10O10OO010OIOllO0IIIII:IO0Oll001000I1I0IIOO101lI10lIIIIII(0 TO IOI111OlI111O1lI0lO1I00O0II10IIIII-1):=(OTHERS=>(OTHERS=>'0'));SIGNAL IOO0l1O1IlO1000Ol10IlOIO00111IIIII:IOI0IlOIlO11lO1OO1ll111101lO1IIIII(0 TO IOI111OlI111O1lI0lO1I00O0II10IIIII-1):=(OTHERS
=>(OTHERS=>'0'));SIGNAL IOO0O01Il01I00O00IO0O0O1ll0O1IIIII:IIIlO001lO010I00O0OOllOO00l01IIIII(0 TO IOI111OlI111O1lI0lO1I00O0II10IIIII-1):=(OTHERS=>(OTHERS=>'0'));SIGNAL IOOIl01IO0lllOIIlIO10l11I000lIIIII:STD_LOGIC_VECTOR(0
 TO IOI111OlI111O1lI0lO1I00O0II10IIIII-1):=(OTHERS=>'0');SIGNAL III00lO01IIlOIllO00O0lIll1O1IIIIII:STD_LOGIC:='0';SIGNAL IOlOI110lOlOI0OI11O000OOIl1IOIIIII:STD_LOGIC:='0';SIGNAL IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII
:STD_LOGIC:='1';SIGNAL III11I1OOl0l0IIOIIIOOOIOl0010IIIII:STD_LOGIC;SIGNAL IOlI00lO001l0IlOIOIlO11IOl011IIIII:STD_LOGIC:='0';SIGNAL IO1O0l0lO001lll1111lO1lOl100OIIIII:STD_LOGIC;SIGNAL
 IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII:STD_LOGIC;SIGNAL IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII:STD_LOGIC;SIGNAL IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII:STD_LOGIC;SIGNAL II0I110I0IllOO1l11O1I0llOlOI1IIIII:STD_LOGIC;BEGIN
 III11I1OOl0l0IIOIIIOOOIOl0010IIIII<=(IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII AND OPERATION_ND)WHEN II1l0l1O010I00O1Ill1O10lIII0OIIIII=0 ELSE(IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII AND OPERATION_ND AND NOT(SCLR));RDY_CNTRL
:PROCESS(CLK,IOlOI110lOlOI0OI11O000OOIl1IOIIIII)BEGIN IF II1l0l1O010I00O1Ill1O10lIII0OIIIII=0 THEN III00lO01IIlOIllO00O0lIll1O1IIIIII<=IOlOI110lOlOI0OI11O000OOIl1IOIIIII;ELSIF RISING_EDGE(CLK)THEN IF SCLR='1'THEN III00lO01IIlOIllO00O0lIll1O1IIIIII<='0';
ELSIF CE='1'THEN III00lO01IIlOIllO00O0lIll1O1IIIIII<=IOlOI110lOlOI0OI11O000OOIl1IOIIIII;END IF;END IF;END PROCESS;RDF_GEN:PROCESS(CLK,III11I1OOl0l0IIOIIIOOOIOl0010IIIII)VARIABLE IOI1000Ol10O11I01I0O1lIII0OlIIIIII:BOOLEAN:=
FALSE;VARIABLE II1lOlIlO10lOOI0llO0lO1O0lO00IIIII:NATURAL RANGE 0 TO C_RATE-1;BEGIN IF II1l0l1O010I00O1Ill1O10lIII0OIIIII=0 THEN IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<='1';ELSIF RISING_EDGE(CLK)THEN IF
 SCLR='1'THEN IOI1000Ol10O11I01I0O1lIII0OlIIIIII:=FALSE;IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<='0';ELSIF CE='1'THEN IF C_RATE>1 THEN IF III11I1OOl0l0IIOIIIOOOIOl0010IIIII='1'THEN IOI1000Ol10O11I01I0O1lIII0OlIIIIII:=TRUE;
ELSIF II1lOlIlO10lOOI0llO0lO1O0lO00IIIII=0 THEN IOI1000Ol10O11I01I0O1lIII0OlIIIIII:=FALSE;END IF;IF III11I1OOl0l0IIOIIIOOOIOl0010IIIII='1'THEN II1lOlIlO10lOOI0llO0lO1O0lO00IIIII:=C_RATE-2;ELSIF IOI1000Ol10O11I01I0O1lIII0OlIIIIII THEN II1lOlIlO10lOOI0llO0lO1O0lO00IIIII:=
II1lOlIlO10lOOI0llO0lO1O0lO00IIIII-1;END IF;END IF;IF IOI1000Ol10O11I01I0O1lIII0OlIIIIII THEN IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<='0';ELSE IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII<='1';END IF;END IF;END IF;END PROCESS;II1l0l1O010I00O1Ill1O10lIII0OIIIII
<=FLT_PT_DELAY(FAMILY=>C_FAMILY,OP_CODE=>OPERATION(FLT_PT_OP_CODE_SLICE),A_WIDTH=>C_A_WIDTH,A_FRACTION_WIDTH=>C_A_FRACTION_WIDTH,
B_WIDTH=>C_B_WIDTH,B_FRACTION_WIDTH=>C_B_FRACTION_WIDTH,RESULT_WIDTH=>C_RESULT_WIDTH,RESULT_FRACTION_WIDTH=>C_RESULT_FRACTION_WIDTH
,OPTIMIZATION=>C_OPTIMIZATION,MULT_USAGE=>C_MULT_USAGE,RATE=>-1,HAS_ADD=>C_HAS_ADD,HAS_SUBTRACT=>C_HAS_SUBTRACT,HAS_MULTIPLY=>
C_HAS_MULTIPLY,HAS_DIVIDE=>C_HAS_DIVIDE,HAS_SQRT=>C_HAS_SQRT,HAS_COMPARE=>C_HAS_COMPARE,HAS_FLT_TO_FIX=>C_HAS_FLT_TO_FIX,
HAS_FIX_TO_FLT=>C_HAS_FIX_TO_FLT,HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,REQUIRED=>C_LATENCY);PROCESS(CLK,A,B,II1l0l1O010I00O1Ill1O10lIII0OIIIII,III11I1OOl0l0IIOIIIOOOIOl0010IIIII,
OPERATION,IOO0O01Il01I00O00IO0O0O1ll0O1IIIII,IOOIl01IO0lllOIIlIO10l11I000lIIIII,IIOI01II0OIl10O10OO010OIOllO0IIIII,IOO0l1O1IlO1000Ol10IlOIO00111IIIII)BEGIN IF II1l0l1O010I00O1Ill1O10lIII0OIIIII=0 THEN IOlII0O0Oll1OO0O1O0O0O111O00lIIIII<=A;IOO1ll00l01O0lI100l10I1OOl0IIOIIII<=B;IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII<=OPERATION;IOlOI110lOlOI0OI11O000OOIl1IOIIIII
<=III11I1OOl0l0IIOIIIOOOIOl0010IIIII;ELSIF II1l0l1O010I00O1Ill1O10lIII0OIIIII=1 THEN IOlOI110lOlOI0OI11O000OOIl1IOIIIII<=III11I1OOl0l0IIOIIIOOOIOl0010IIIII;IF RISING_EDGE(CLK)THEN IF CE='1'THEN IOlII0O0Oll1OO0O1O0O0O111O00lIIIII<=A;IOO1ll00l01O0lI100l10I1OOl0IIOIIII<=B;
IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII<=OPERATION;END IF;END IF;ELSE IF RISING_EDGE(CLK)THEN IF SCLR='1'THEN IF CE='1'THEN IIOI01II0OIl10O10OO010OIOllO0IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=A&IIOI01II0OIl10O10OO010OIOllO0IIIII(0
 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);IOO0l1O1IlO1000Ol10IlOIO00111IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=B&IOO0l1O1IlO1000Ol10IlOIO00111IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);IOO0O01Il01I00O00IO0O0O1ll0O1IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=OPERATION&IOO0O01Il01I00O00IO0O0O1ll0O1IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);
END IF;IOOIl01IO0lllOIIlIO10l11I000lIIIII<=(OTHERS=>'0');ELSIF CE='1'THEN IIOI01II0OIl10O10OO010OIOllO0IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=A&IIOI01II0OIl10O10OO010OIOllO0IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);IOO0l1O1IlO1000Ol10IlOIO00111IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=B&IOO0l1O1IlO1000Ol10IlOIO00111IIIII(0
 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);IOO0O01Il01I00O00IO0O0O1ll0O1IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=OPERATION&IOO0O01Il01I00O00IO0O0O1ll0O1IIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);IOOIl01IO0lllOIIlIO10l11I000lIIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-1)<=III11I1OOl0l0IIOIIIOOOIOl0010IIIII&
IOOIl01IO0lllOIIlIO10l11I000lIIIII(0 TO II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);END IF;END IF;IOlII0O0Oll1OO0O1O0O0O111O00lIIIII<=IIOI01II0OIl10O10OO010OIOllO0IIIII(II1l0l1O010I00O1Ill1O10lIII0OIIIII-1);IOO1ll00l01O0lI100l10I1OOl0IIOIIII<=IOO0l1O1IlO1000Ol10IlOIO00111IIIII(II1l0l1O010I00O1Ill1O10lIII0OIIIII-1);IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII<=IOO0O01Il01I00O00IO0O0O1ll0O1IIIII(II1l0l1O010I00O1Ill1O10lIII0OIIIII-1);
IOlOI110lOlOI0OI11O000OOIl1IOIIIII<=IOOIl01IO0lllOIIlIO10l11I000lIIIII(II1l0l1O010I00O1Ill1O10lIII0OIIIII-2);END IF;END PROCESS;PROCESS(IOlII0O0Oll1OO0O1O0O0O111O00lIIIII,IOO1ll00l01O0lI100l10I1OOl0IIOIIII,IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII)VARIABLE IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII:STD_LOGIC_VECTOR(
C_RESULT_WIDTH-1 DOWNTO 0);VARIABLE II0I1O11I0IIlOlO111O1O0l010OIOIIII:STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);VARIABLE IOIOl1IO110100l0OIl0IIlIOO0IIOIIII:STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO
 0);VARIABLE III0ll0lIll1lIO11lOlIl0IO000IIIIII:STD_LOGIC;VARIABLE II10OIl0OO0IOIO111ll0Ill01l0OIIIII:STD_LOGIC;VARIABLE IIOlIIIIIlIIl0III10OO1OlI00lIOIIII:STD_LOGIC;VARIABLE IOll11O00IlllIl0l1I1I00l0IIOIIIIII:
STD_LOGIC;VARIABLE IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII:STD_LOGIC;VARIABLE IOl0OlI0OIlOIl11I0l0IlOOI01OOIIIII:BOOLEAN;VARIABLE IOI100O1O001OlIl001l1011IOll1IIIII:BOOLEAN;VARIABLE IO0l1OlI0l011l0lO1O11OlOO0lllIIIII:BOOLEAN;VARIABLE
 IOO0lIO01Ill01OO1Il00OO00I1l1IIIII:BOOLEAN;VARIABLE IO11I0OIOIllIII10I01I1lO01IOIIIIII:BOOLEAN;VARIABLE IOIOll10I0lOl0I0IOOIl0IlI101IIIIII:BOOLEAN;VARIABLE IOl0OO0lOI1O0l0I1lIlI00lO0llOIIIII:BOOLEAN;BEGIN II0I1O11I0IIlOlO111O1O0l010OIOIIII:=IOlII0O0Oll1OO0O1O0O0O111O00lIIIII;IOIOl1IO110100l0OIl0IIlIOO0IIOIIII
:=IOO1ll00l01O0lI100l10I1OOl0IIOIIII;III0ll0lIll1lIO11lOlIl0IO000IIIIII:='0';II10OIl0OO0IOIO111ll0Ill01l0OIIIII:='0';IIOlIIIIIlIIl0III10OO1OlI00lIOIIII:='0';IOll11O00IlllIl0l1I1I00l0IIOIIIIII:='0';IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII:='0';IOl0OO0lOI1O0l0I1lIlI00lO0llOIIIII:=(
FLT_PT_NUMBER_OF_INPUTS(CONV_INTEGER(UNSIGNED(OPERATION(FLT_PT_OP_CODE_SLICE))))=2);IF(CONV_INTEGER(UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(
FLT_PT_OP_CODE_SLICE)))/=FLT_PT_FIX_TO_FLT_OP_CODE)AND C_A_FRACTION_WIDTH>1 THEN IOl0OlI0OIlOIl11I0l0IlOOI01OOIIIII:=FLT_PT_IS_NAN(C_A_WIDTH,
C_A_FRACTION_WIDTH,II0I1O11I0IIlOlO111O1O0l010OIOIIII);IOI100O1O001OlIl001l1011IOll1IIIII:=FLT_PT_IS_NAN(C_B_WIDTH,C_B_FRACTION_WIDTH,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII);IO0l1OlI0l011l0lO1O11OlOO0lllIIIII:=FLT_PT_IS_SIGNALLING_NAN(
C_A_WIDTH,C_A_FRACTION_WIDTH,II0I1O11I0IIlOlO111O1O0l010OIOIIII);IOO0lIO01Ill01OO1Il00OO00I1l1IIIII:=FLT_PT_IS_SIGNALLING_NAN(C_B_WIDTH,C_B_FRACTION_WIDTH,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII);IO11I0OIOIllIII10I01I1lO01IOIIIIII:=
FLT_PT_IS_DENORMALIZED(C_A_WIDTH,C_A_FRACTION_WIDTH,II0I1O11I0IIlOlO111O1O0l010OIOIIII);IOIOll10I0lOl0I0IOOIl0IlI101IIIIII:=FLT_PT_IS_DENORMALIZED(C_B_WIDTH,C_B_FRACTION_WIDTH,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII);
ELSE IOl0OlI0OIlOIl11I0l0IlOOI01OOIIIII:=FALSE;IOI100O1O001OlIl001l1011IOll1IIIII:=FALSE;IO0l1OlI0l011l0lO1O11OlOO0lllIIIII:=FALSE;IOO0lIO01Ill01OO1Il00OO00I1l1IIIII:=FALSE;IO11I0OIOIllIII10I01I1lO01IOIIIIII:=FALSE;IOIOll10I0lOl0I0IOOIl0IlI101IIIIII:=FALSE;END IF;IF(
IOl0OlI0OIlOIl11I0l0IlOOI01OOIIIII OR(IOI100O1O001OlIl001l1011IOll1IIIII AND IOl0OO0lOI1O0l0I1lIlI00lO0llOIIIII))AND(CONV_INTEGER(UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_OP_CODE_SLICE)))/=FLT_PT_COMPARE_OP_CODE)THEN IF(
CONV_INTEGER(UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_OP_CODE_SLICE)))=FLT_PT_FLT_TO_FIX_OP_CODE)THEN IF(C_OPTIMIZATION=FLT_PT_COMBINED AND
 IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_SPECIAL_SLICE)='1'AND(C_RESULT_WIDTH=64 AND C_RESULT_FRACTION_WIDTH=53))THEN IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII(C_RESULT_WIDTH/2-1
 DOWNTO 0):=FLT_PT_GET_MOST_NEGATIVE_FIX(C_RESULT_WIDTH/2);IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII(C_RESULT_WIDTH-1 DOWNTO C_RESULT_WIDTH/2):=(OTHERS=>'0');ELSE
 IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII:=FLT_PT_GET_MOST_NEGATIVE_FIX(C_RESULT_WIDTH);END IF;III0ll0lIll1lIO11lOlIl0IO000IIIIII:='1';ELSE IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII:=FLT_PT_GET_QUIET_NAN(
C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH);III0ll0lIll1lIO11lOlIl0IO000IIIIII:='0';END IF;ELSIF(IO11I0OIOIllIII10I01I1lO01IOIIIIII OR(IOIOll10I0lOl0I0IOOIl0IlI101IIIIII AND IOl0OO0lOI1O0l0I1lIlI00lO0llOIIIII))AND(CONV_INTEGER(
UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_OP_CODE_SLICE)))/=FLT_PT_COMPARE_OP_CODE)AND FALSE THEN IF(CONV_INTEGER(UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(
FLT_PT_OP_CODE_SLICE)))=FLT_PT_FLT_TO_FIX_OP_CODE)THEN IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII:=(OTHERS=>'0');ELSE IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII:=FLT_PT_GET_QUIET_NAN(
C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH);IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII:='1';END IF;ELSE IF TRUE THEN IF IO11I0OIOIllIII10I01I1lO01IOIIIIII THEN II0I1O11I0IIlOlO111O1O0l010OIOIIII(C_A_WIDTH-2 DOWNTO 0):=(
OTHERS=>'0');IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII:='1';END IF;IF IOIOll10I0lOl0I0IOOIl0IlI101IIIIII THEN IOIOl1IO110100l0OIl0IIlIOO0IIOIIII(C_B_WIDTH-2 DOWNTO 0):=(OTHERS=>'0');IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII:='1';END IF;END IF;
CASE CONV_INTEGER(UNSIGNED(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_OP_CODE_SLICE)))IS WHEN FLT_PT_SQRT_OP_CODE=>IF(C_HAS_FLT_TO_FLT=FLT_PT_YES)THEN
 II0I1O11OOll0l0I11O110OlI0lIOOIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,
II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);ELSE IF((C_RESULT_WIDTH=C_A_WIDTH)AND(C_RESULT_FRACTION_WIDTH=C_A_FRACTION_WIDTH))THEN II1IOOO1II0l1lOl00I1O001I00O0IIIII(
C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;END IF;WHEN
 FLT_PT_DIVIDE_OP_CODE=>IF((C_RESULT_WIDTH=C_A_WIDTH)AND(C_RESULT_FRACTION_WIDTH=C_A_FRACTION_WIDTH)AND(C_RESULT_WIDTH=C_B_WIDTH)AND
(C_RESULT_FRACTION_WIDTH=C_B_FRACTION_WIDTH))THEN IIIIl1100lOI0I1OO1I00OlI0l10IIIIII(C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,0,0,'0','0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII,
IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII,IIOlIIIIIlIIl0III10OO1OlI00lIOIIII);END IF;WHEN FLT_PT_MULTIPLY_OP_CODE=>IF((C_RESULT_WIDTH=
C_A_WIDTH)AND(C_RESULT_FRACTION_WIDTH=C_A_FRACTION_WIDTH)AND(C_RESULT_WIDTH=C_B_WIDTH)AND(C_RESULT_FRACTION_WIDTH=C_B_FRACTION_WIDTH
))THEN II1011O1IO1l0llOI11lIIOIlOlIlIIIII(C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH,0,0,'0','0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,
IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;WHEN FLT_PT_ADD_OP_CODE=>IF C_HAS_ADD=FLT_PT_TRUE THEN IOl00OIO0IOOllO1I1O101lIIl11OIIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,0,0,'0','0',
II0I1O11I0IIlOlO111O1O0l010OIOIIII,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;WHEN FLT_PT_SUBTRACT_OP_CODE=>IF C_HAS_SUBTRACT=FLT_PT_TRUE
 THEN IOl00OIO0IOOllO1I1O101lIIl11OIIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,0,0,'0','1',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;
WHEN FLT_PT_COMPARE_OP_CODE=>IIIO01IOl00Il00111I010ll11010IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,0,0,'0','0',IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(
FLT_PT_COMPARE_OPERATION_SLICE),II0I1O11I0IIlOlO111O1O0l010OIOIIII,IOIOl1IO110100l0OIl0IIlIOO0IIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII);WHEN FLT_PT_FLT_TO_FIX_OP_CODE=>IF C_OPTIMIZATION=
FLT_PT_COMBINED THEN IF(IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_SPECIAL_SLICE)='1'AND(C_RESULT_WIDTH=64 AND C_RESULT_FRACTION_WIDTH=53))THEN
 IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH/2,0,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_ROUND_MODE_SLICE),IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII(
C_RESULT_WIDTH/2-1 DOWNTO 0),III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII(C_RESULT_WIDTH-1 DOWNTO C_RESULT_WIDTH/2):=(
OTHERS=>'0');ELSE IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,0,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO01Ol1OI1IO0OOIOIl01l001OI1OIIIII(FLT_PT_ROUND_MODE_SLICE
),IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;ELSE IIOII0OO1Ol0lOOlO1O1OOlllIllOIIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,
C_RESULT_FRACTION_WIDTH,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,FLT_PT_RND_TO_NEAREST_EVEN,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;WHEN
 FLT_PT_FIX_TO_FLT_OP_CODE=>IF C_OPTIMIZATION=FLT_PT_COMBINED THEN II1l0I0l10l0I1I1lO01l10I01lI1IIIII(C_A_WIDTH,0,C_A_WIDTH,C_A_FRACTION_WIDTH,0,'0',
II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);ELSE II1l0I0l10l0I1I1lO01l10I01lI1IIIII(C_A_WIDTH,C_A_FRACTION_WIDTH,C_RESULT_WIDTH,
C_RESULT_FRACTION_WIDTH,0,'0',II0I1O11I0IIlOlO111O1O0l010OIOIIII,IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII,III0ll0lIll1lIO11lOlIl0IO000IIIIII,II10OIl0OO0IOIO111ll0Ill01l0OIIIII,IOll11O00IlllIl0l1I1I00l0IIOIIIIII);END IF;WHEN OTHERS=>ASSERT(FALSE)REPORT
"Internal error: flt_pt_operation(behavioral)"&" - contact Xilinx support"SEVERITY FAILURE;END CASE;END IF;RESULT<=IO0O100O1O0IlIl1OII1I0lOI0IO1IIIII;
IO1O0l0lO001lll1111lO1lOl100OIIIII<=III0ll0lIll1lIO11lOlIl0IO000IIIIII;IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII<=II10OIl0OO0IOIO111ll0Ill01l0OIIIII;IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII<=IOll11O00IlllIl0l1I1I00l0IIOIIIIII;IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII<=IIOlIIIIIlIIl0III10OO1OlI00lIOIIII;
II0I110I0IllOO1l11O1I0llOlOI1IIIII<=IIO1O11O1010OI0l1lI1IO0O1OlIIIIIII;END PROCESS;OPERATION_RFD<=IO101lI0lO1OI00OIOO1lOI1l1lIIOIIII;YES_EARLY:IF C_STATUS_EARLY=FLT_PT_YES GENERATE RDY<=
IOlOI110lOlOI0OI11O000OOIl1IOIIIII;END GENERATE;NO_EARLY:IF C_STATUS_EARLY=FLT_PT_NO GENERATE RDY<=III00lO01IIlOIllO00O0lIll1O1IIIIII;END GENERATE;INVALID_OP<=IO1O0l0lO001lll1111lO1lOl100OIIIII;
OVERFLOW<=IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII;UNDERFLOW<=IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII;DIVIDE_BY_ZERO<=IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII;STATUS<=IO1O0l0lO001lll1111lO1lOl100OIIIII&IIlIIlIl01lOl1O00Ol00OOOIO1I0IIIII&
IOIIOO0OlOOll0II1IOOI0IO0Il11IIIII&IOIOlOOOOl01l0I1l0OI1Il1l1OO1IIIII&II0I110I0IllOO1l11O1I0llOlOI1IIIII;END;LIBRARY IEEE;USE IEEE.STD_LOGIC_1164.ALL;USE IEEE.STD_LOGIC_ARITH.ALL;LIBRARY
 XILINXCORELIB;USE XILINXCORELIB.FLOATING_POINT_V4_0_CONSTS.ALL;USE XILINXCORELIB.FLOATING_POINT_PKG_V4_0.ALL;ENTITY
 FLOATING_POINT_V4_0_XST IS GENERIC(C_XDEVICEFAMILY:STRING:=C_FAMILY_DEFAULT;C_HAS_ADD:INTEGER:=C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:
INTEGER:=C_HAS_SUBTRACT_DEFAULT;C_HAS_MULTIPLY:INTEGER:=C_HAS_MULTIPLY_DEFAULT;C_HAS_DIVIDE:INTEGER:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT
:INTEGER:=C_HAS_SQRT_DEFAULT;C_HAS_COMPARE:INTEGER:=C_HAS_COMPARE_DEFAULT;C_HAS_FIX_TO_FLT:INTEGER:=C_HAS_FIX_TO_FLT_DEFAULT;
C_HAS_FLT_TO_FIX:INTEGER:=C_HAS_FLT_TO_FIX_DEFAULT;C_HAS_FLT_TO_FLT:INTEGER:=C_HAS_FLT_TO_FLT_DEFAULT;C_A_WIDTH:INTEGER:=
C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH:INTEGER:=C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:INTEGER:=C_B_WIDTH_DEFAULT;C_B_FRACTION_WIDTH:
INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;C_RESULT_FRACTION_WIDTH:INTEGER:=
C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY:INTEGER:=C_LATENCY_DEFAULT;
C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER:=C_RATE_DEFAULT;C_HAS_ACLR
:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;C_HAS_A_NEGATE:INTEGER:=
C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT;C_HAS_A_RFD:INTEGER:=
C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;C_HAS_OPERATION_ND:INTEGER:=
C_HAS_OPERATION_ND_DEFAULT;C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=C_HAS_RDY_DEFAULT;C_HAS_CTS:
INTEGER:=C_HAS_CTS_DEFAULT;C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=C_HAS_OVERFLOW_DEFAULT;
C_HAS_INVALID_OP:INTEGER:=C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;C_HAS_DIVIDE_BY_ZERO:INTEGER:=
C_HAS_DIVIDE_BY_ZERO_DEFAULT;C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=C_HAS_EXCEPTION_DEFAULT;
C_STATUS_EARLY:INTEGER:=C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT);PORT(A:IN STD_LOGIC_VECTOR(C_A_WIDTH-1 DOWNTO 0);B
:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_NEGATE:IN STD_LOGIC:='0';B_NEGATE:IN STD_LOGIC:='0';OPERATION:IN
 STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_ND:IN STD_LOGIC:='1';A_RFD:OUT STD_LOGIC;B_ND:IN STD_LOGIC:=
'1';B_RFD:OUT STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';OPERATION_RFD:OUT STD_LOGIC;CLK:IN STD_LOGIC;SCLR:IN STD_LOGIC:='0';ACLR:IN
 STD_LOGIC:='0';CE:IN STD_LOGIC:='1';RESULT:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);STATUS:OUT STD_LOGIC_VECTOR(
FLT_PT_STATUS_WIDTH-1 DOWNTO 0);EXCEPTION:OUT STD_LOGIC;UNDERFLOW:OUT STD_LOGIC;OVERFLOW:OUT STD_LOGIC;INVALID_OP:OUT STD_LOGIC;
INEXACT:OUT STD_LOGIC;DIVIDE_BY_ZERO:OUT STD_LOGIC;RDY:OUT STD_LOGIC;CTS:IN STD_LOGIC:='1');END;ARCHITECTURE BEHAVIORAL OF
 FLOATING_POINT_V4_0_XST IS COMPONENT FLT_PT_OPERATOR_V4_0 GENERIC(C_FAMILY:STRING:=C_FAMILY_DEFAULT;C_HAS_ADD:INTEGER:=
C_HAS_ADD_DEFAULT;C_HAS_SUBTRACT:INTEGER:=C_HAS_SUBTRACT_DEFAULT;C_HAS_MULTIPLY:INTEGER:=C_HAS_MULTIPLY_DEFAULT;C_HAS_DIVIDE:INTEGER
:=C_HAS_DIVIDE_DEFAULT;C_HAS_SQRT:INTEGER:=C_HAS_SQRT_DEFAULT;C_HAS_COMPARE:INTEGER:=C_HAS_COMPARE_DEFAULT;C_HAS_FIX_TO_FLT:INTEGER
:=C_HAS_FIX_TO_FLT_DEFAULT;C_HAS_FLT_TO_FIX:INTEGER:=C_HAS_FLT_TO_FIX_DEFAULT;C_HAS_FLT_TO_FLT:INTEGER:=C_HAS_FLT_TO_FLT_DEFAULT;
C_A_WIDTH:INTEGER:=C_A_WIDTH_DEFAULT;C_A_FRACTION_WIDTH:INTEGER:=C_A_FRACTION_WIDTH_DEFAULT;C_B_WIDTH:INTEGER:=C_B_WIDTH_DEFAULT;
C_B_FRACTION_WIDTH:INTEGER:=C_B_FRACTION_WIDTH_DEFAULT;C_RESULT_WIDTH:INTEGER:=C_RESULT_WIDTH_DEFAULT;C_RESULT_FRACTION_WIDTH:
INTEGER:=C_RESULT_FRACTION_WIDTH_DEFAULT;C_COMPARE_OPERATION:INTEGER:=C_COMPARE_OPERATION_DEFAULT;C_LATENCY:INTEGER:=
C_LATENCY_DEFAULT;C_OPTIMIZATION:INTEGER:=C_OPTIMIZATION_DEFAULT;C_MULT_USAGE:INTEGER:=C_MULT_USAGE_DEFAULT;C_RATE:INTEGER:=
C_RATE_DEFAULT;C_HAS_ACLR:INTEGER:=C_HAS_ACLR_DEFAULT;C_HAS_CE:INTEGER:=C_HAS_CE_DEFAULT;C_HAS_SCLR:INTEGER:=C_HAS_SCLR_DEFAULT;
C_HAS_A_NEGATE:INTEGER:=C_HAS_A_NEGATE_DEFAULT;C_HAS_B_NEGATE:INTEGER:=C_HAS_B_NEGATE_DEFAULT;C_HAS_A_ND:INTEGER:=C_HAS_A_ND_DEFAULT
;C_HAS_A_RFD:INTEGER:=C_HAS_A_RFD_DEFAULT;C_HAS_B_ND:INTEGER:=C_HAS_B_ND_DEFAULT;C_HAS_B_RFD:INTEGER:=C_HAS_B_RFD_DEFAULT;
C_HAS_OPERATION_ND:INTEGER:=C_HAS_OPERATION_ND_DEFAULT;C_HAS_OPERATION_RFD:INTEGER:=C_HAS_OPERATION_RFD_DEFAULT;C_HAS_RDY:INTEGER:=
C_HAS_RDY_DEFAULT;C_HAS_CTS:INTEGER:=C_HAS_CTS_DEFAULT;C_HAS_UNDERFLOW:INTEGER:=C_HAS_UNDERFLOW_DEFAULT;C_HAS_OVERFLOW:INTEGER:=
C_HAS_OVERFLOW_DEFAULT;C_HAS_INVALID_OP:INTEGER:=C_HAS_INVALID_OP_DEFAULT;C_HAS_INEXACT:INTEGER:=C_HAS_INEXACT_DEFAULT;
C_HAS_DIVIDE_BY_ZERO:INTEGER:=C_HAS_DIVIDE_BY_ZERO_DEFAULT;C_HAS_STATUS:INTEGER:=C_HAS_STATUS_DEFAULT;C_HAS_EXCEPTION:INTEGER:=
C_HAS_EXCEPTION_DEFAULT;C_STATUS_EARLY:INTEGER:=C_STATUS_EARLY_DEFAULT;C_SPEED:INTEGER:=C_SPEED_DEFAULT);PORT(A:IN STD_LOGIC_VECTOR
(C_A_WIDTH-1 DOWNTO 0);B:IN STD_LOGIC_VECTOR(C_B_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_NEGATE:IN STD_LOGIC:='0';B_NEGATE:IN STD_LOGIC
:='0';OPERATION:IN STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0):=(OTHERS=>'0');A_ND:IN STD_LOGIC:='1';A_RFD:OUT STD_LOGIC;
B_ND:IN STD_LOGIC:='1';B_RFD:OUT STD_LOGIC;OPERATION_ND:IN STD_LOGIC:='1';OPERATION_RFD:OUT STD_LOGIC;CLK:IN STD_LOGIC;SCLR:IN
 STD_LOGIC:='0';ACLR:IN STD_LOGIC:='0';CE:IN STD_LOGIC:='1';RESULT:OUT STD_LOGIC_VECTOR(C_RESULT_WIDTH-1 DOWNTO 0);STATUS:OUT
 STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0);EXCEPTION:OUT STD_LOGIC;UNDERFLOW:OUT STD_LOGIC;OVERFLOW:OUT STD_LOGIC;INVALID_OP
:OUT STD_LOGIC;INEXACT:OUT STD_LOGIC;DIVIDE_BY_ZERO:OUT STD_LOGIC;RDY:OUT STD_LOGIC;CTS:IN STD_LOGIC:='1');END COMPONENT;FUNCTION
 II0lO111OllO1OIl0IOlIIO011lllIIIII(IOIIllIIII01O1l0OI1llO10Il1OIIIIII,IIO1llO1I11I00l1IIl1III0I0OOIOIIII,IO1lllO01Il1110I10OIO0I01lIlOIIIII,II11llI1IOI1l1OI0I11ll1l1Ol0IOIIII,IOlIOIlOllOlO00IOO1I1IllIOll0IIIII,IO11l0IlIIIlO10l0IlOI0OI1IOOlIIIII,IIOOO001O1011l1OOO0I001lI0ll0IIIII,IIIIOOI1OIl1IlOOI1OOOlIl0lOlIIIIII,
II1I1l1lIIlO1lOOl10O0Oll100I0IIIII:INTEGER)RETURN INTEGER IS BEGIN IF(IOIIllIIII01O1l0OI1llO10Il1OIIIIII=FLT_PT_YES)OR(IIO1llO1I11I00l1IIl1III0I0OOIOIIII=FLT_PT_YES)OR(IO1lllO01Il1110I10OIO0I01lIlOIIIII=FLT_PT_YES)
OR(II11llI1IOI1l1OI0I11ll1l1Ol0IOIIII=FLT_PT_YES)OR(IO11l0IlIIIlO10l0IlOI0OI1IOOlIIIII=FLT_PT_YES)THEN RETURN(FLT_PT_YES);ELSE RETURN(FLT_PT_NO);END IF;END;FUNCTION
 IOl0010llO1Ol00O0OOlII1I1IlI0IIIII(IO0O1II1OI11100IO0III1l1OI0IIIIIII,IO0Ol000l0lOll0O0OOO0lOII00lIIIIII:INTEGER)RETURN INTEGER IS BEGIN IF(IO0O1II1OI11100IO0III1l1OI0IIIIIII=FLT_PT_YES)OR(IO0Ol000l0lOll0O0OOO0lOII00lIIIIII=
FLT_PT_YES)THEN RETURN(FLT_PT_YES);ELSE RETURN(FLT_PT_NO);END IF;END;FUNCTION II1IIIlIl111lO10II01O1l0IOlIIIIIII(IOI0IIl1lIOI11l111I0I0lIIlOOlIIIII:STD_LOGIC_VECTOR(
FLT_PT_OPERATION_WIDTH-1 DOWNTO 0))RETURN STD_LOGIC IS BEGIN RETURN(IOI0IIl1lIOI11l111I0I0lIIlOOlIIIII(0));END;SIGNAL II01OOI10II1IIl1I11lI1II10IIOIIIII:BOOLEAN:=
FLOATING_POINT_V4_0_CHECK(C_FAMILY=>C_XDEVICEFAMILY,C_HAS_ADD=>C_HAS_ADD,C_HAS_SUBTRACT=>C_HAS_SUBTRACT,C_HAS_MULTIPLY=>
C_HAS_MULTIPLY,C_HAS_DIVIDE=>C_HAS_DIVIDE,C_HAS_SQRT=>C_HAS_SQRT,C_HAS_COMPARE=>C_HAS_COMPARE,C_HAS_FLT_TO_FIX=>C_HAS_FLT_TO_FIX,
C_HAS_FIX_TO_FLT=>C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,C_A_WIDTH=>C_A_WIDTH,C_A_FRACTION_WIDTH=>C_A_FRACTION_WIDTH,
C_B_WIDTH=>C_B_WIDTH,C_B_FRACTION_WIDTH=>C_B_FRACTION_WIDTH,C_RESULT_WIDTH=>C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH=>
C_RESULT_FRACTION_WIDTH,C_COMPARE_OPERATION=>C_COMPARE_OPERATION,C_OPTIMIZATION=>C_OPTIMIZATION,C_MULT_USAGE=>C_MULT_USAGE,C_LATENCY
=>C_LATENCY,C_RATE=>C_RATE,C_HAS_SCLR=>C_HAS_SCLR,C_HAS_CE=>C_HAS_CE,C_HAS_OPERATION_ND=>C_HAS_OPERATION_ND,C_HAS_OPERATION_RFD=>
C_HAS_OPERATION_RFD,C_HAS_RDY=>C_HAS_RDY,C_HAS_UNDERFLOW=>C_HAS_UNDERFLOW,C_HAS_OVERFLOW=>C_HAS_OVERFLOW,C_HAS_INVALID_OP=>
C_HAS_INVALID_OP,C_HAS_DIVIDE_BY_ZERO=>C_HAS_DIVIDE_BY_ZERO,C_HAS_EXCEPTION=>C_HAS_EXCEPTION,C_STATUS_EARLY=>C_STATUS_EARLY,C_SPEED
=>C_SPEED);CONSTANT IOlOlO1Illll100l0lO1OI11IIOllIIIII:INTEGER:=IOl0010llO1Ol00O0OOlII1I1IlI0IIIII(C_HAS_ADD,C_HAS_SUBTRACT);CONSTANT IIO0IIO0I000OIOIl1O00010Ill11IIIII
:INTEGER:=FLT_PT_NUMBER_OF_OPERATIONS(C_HAS_ADD,C_HAS_SUBTRACT,C_HAS_MULTIPLY,C_HAS_DIVIDE,C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT
,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);CONSTANT II0IlOOIIlO0II0O1OOOIlOI1I10IIIIII:INTEGER:=II0lO111OllO1OIl0IOlIIO011lllIIIII(C_HAS_ADD,C_HAS_SUBTRACT,C_HAS_MULTIPLY,C_HAS_DIVIDE,
C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);CONSTANT II1l1lO1IllI1OI1l0OlOOIl111OlIIIII:BOOLEAN:=(C_HAS_ADD=
FLT_PT_YES AND C_HAS_SUBTRACT=FLT_PT_YES);CONSTANT IO0lIIllO0OIlIO0I1l0IIlII0l1IOIIII:INTEGER:=C_A_WIDTH;CONSTANT IOlI1IlIO1O010Il1III1O0lO001IOIIII:INTEGER:=
C_A_FRACTION_WIDTH;SIGNAL IIlIl1100IO000lIO0l10IO1Ol01IOIIII:STD_LOGIC;SIGNAL IO0Il0OI0IOI0O1OIlO1I1IIO000lIIIII:STD_LOGIC;SIGNAL IOI0l1OOO0lllllI1l1OIOO0I1Il1IIIII:STD_LOGIC;SIGNAL
 II1OO0I1Ill1I01lO1l0IllOlO11IIIIII:STD_LOGIC;SIGNAL IOIOO1ll1O0Il0100001l1l1O1IIOOIIII:STD_LOGIC;SIGNAL IO1lO0OOOI1111lOOl0lO00Il011IIIIII:STD_LOGIC;SIGNAL IOII10010000l0II10OlOOllOl1IOIIIII:STD_LOGIC;SIGNAL IOI1l0lII1II11Ill10III0111II1IIIII:
STD_LOGIC;SIGNAL IO1I01IOIlI0llO0OI0l10l00IlI0IIIII:STD_LOGIC;SIGNAL IIll0O11I1IlIOOl1l100lOIOI1IIOIIII:STD_LOGIC_VECTOR(FLT_PT_STATUS_WIDTH-1 DOWNTO 0);SIGNAL IO0Oll1llll1l100Il00OO110lO10IIIII:STD_LOGIC;
SIGNAL III0IOl1OI0OO01O10OIlO0lO0OOIOIIII:STD_LOGIC_VECTOR(FLT_PT_OPERATION_WIDTH-1 DOWNTO 0);SIGNAL IO00l1llO0I0OOOI0II0I0O110111IIIII:STD_LOGIC_VECTOR(IO0lIIllO0OIlIO0I1l0IIlII0l1IOIIII-1 DOWNTO 0);BEGIN
 ASSERT(II01OOI10II1IIl1I11lI1II10IIOIIIII)REPORT"ERROR : The generics are out of range. Please change."SEVERITY FAILURE;YES_B:IF II0IlOOIIlO0II0O1OOOIlOI1I10IIIIII=FLT_PT_YES GENERATE IO00l1llO0I0OOOI0II0I0O110111IIIII
<=EXT(B,IO0lIIllO0OIlIO0I1l0IIlII0l1IOIIII);END GENERATE;NO_B:IF II0IlOOIIlO0II0O1OOOIlOI1I10IIIIII/=FLT_PT_YES GENERATE IO00l1llO0I0OOOI0II0I0O110111IIIII<=(OTHERS=>'0');END GENERATE;YES_CE:IF C_HAS_CE=FLT_PT_YES
 GENERATE IOIOO1ll1O0Il0100001l1l1O1IIOOIIII<=CE;END GENERATE;NO_CE:IF C_HAS_CE/=FLT_PT_YES GENERATE IOIOO1ll1O0Il0100001l1l1O1IIOOIIII<='1';END GENERATE;YES_SCLR:IF C_HAS_SCLR=FLT_PT_YES
 GENERATE IO1lO0OOOI1111lOOl0lO00Il011IIIIII<=SCLR;END GENERATE;NO_SCLR:IF C_HAS_SCLR/=FLT_PT_YES GENERATE IO1lO0OOOI1111lOOl0lO00Il011IIIIII<='0';END GENERATE;YES_OPERATION_ND:IF
 C_HAS_OPERATION_ND=FLT_PT_YES GENERATE IOII10010000l0II10OlOOllOl1IOIIIII<=OPERATION_ND;END GENERATE;NO_OPERATION_ND:IF C_HAS_OPERATION_ND/=FLT_PT_YES
 GENERATE IOII10010000l0II10OlOOllOl1IOIIIII<='1';END GENERATE;YES_OPERATION_RFD:IF C_HAS_OPERATION_RFD=FLT_PT_YES GENERATE OPERATION_RFD<=
IOI1l0lII1II11Ill10III0111II1IIIII;END GENERATE;NO_OPERATION_RFD:IF C_HAS_OPERATION_RFD/=FLT_PT_YES GENERATE OPERATION_RFD<='X';END GENERATE;YES_RDY:
IF C_HAS_RDY=FLT_PT_YES GENERATE RDY<=IO1I01IOIlI0llO0OI0l10l00IlI0IIIII;END GENERATE;NO_RDY:IF C_HAS_RDY/=FLT_PT_YES GENERATE RDY<='X';END GENERATE;
YES_UNDERFLOW:IF C_HAS_UNDERFLOW=FLT_PT_YES GENERATE UNDERFLOW<=IIlIl1100IO000lIO0l10IO1Ol01IOIIII;END GENERATE;NO_UNDERFLOW:IF C_HAS_UNDERFLOW/=
FLT_PT_YES GENERATE UNDERFLOW<='X';END GENERATE;YES_OVERFLOW:IF C_HAS_OVERFLOW=FLT_PT_YES GENERATE OVERFLOW<=IO0Il0OI0IOI0O1OIlO1I1IIO000lIIIII;END
 GENERATE;NO_OVERFLOW:IF C_HAS_OVERFLOW/=FLT_PT_YES GENERATE OVERFLOW<='X';END GENERATE;YES_INVALID_OP:IF C_HAS_INVALID_OP=
FLT_PT_YES GENERATE INVALID_OP<=II1OO0I1Ill1I01lO1l0IllOlO11IIIIII;END GENERATE;NO_INVALID_OP:IF C_HAS_INVALID_OP/=FLT_PT_YES GENERATE INVALID_OP<='X';
END GENERATE;YES_DIVIDE_BY_ZERO:IF(C_HAS_DIVIDE_BY_ZERO=FLT_PT_YES)GENERATE DIVIDE_BY_ZERO<=IOI0l1OOO0lllllI1l1OIOO0I1Il1IIIII;END GENERATE;
NO_DIVIDE_BY_ZERO:IF(C_HAS_DIVIDE_BY_ZERO/=FLT_PT_YES)GENERATE DIVIDE_BY_ZERO<='X';END GENERATE;YES_EXCEPTION:IF C_HAS_EXCEPTION=
FLT_PT_YES GENERATE EXCEPTION<=IO0Oll1llll1l100Il00OO110lO10IIIII;END GENERATE;NO_EXCEPTION:IF C_HAS_EXCEPTION/=FLT_PT_YES GENERATE EXCEPTION<='X';END
 GENERATE;YES_STATUS:IF C_HAS_STATUS=FLT_PT_YES GENERATE STATUS<=IIll0O11I1IlIOOl1l100lOIOI1IIOIIII;END GENERATE;NO_STATUS:IF C_HAS_STATUS=FLT_PT_NO GENERATE
 STATUS<=(OTHERS=>'X');END GENERATE;YES_COMPARE:IF C_HAS_COMPARE=FLT_PT_YES GENERATE PROG_COMPARE:IF C_COMPARE_OPERATION=
FLT_PT_PROGRAMMABLE GENERATE III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_COMPARE_OPERATION_SLICE)<=OPERATION(FLT_PT_COMPARE_OPERATION_SLICE);END GENERATE;
FIXED_COMPARE:IF C_COMPARE_OPERATION/=FLT_PT_PROGRAMMABLE GENERATE III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_COMPARE_OPERATION_SLICE)<=
CONV_STD_LOGIC_VECTOR(C_COMPARE_OPERATION,FLT_PT_COMPARE_OPERATION_WIDTH);END GENERATE;END GENERATE;OPERATION_RQD:IF
 IIO0IIO0I000OIOIl1O00010Ill11IIIII>1 GENERATE III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_OP_CODE_SLICE)<=OPERATION(FLT_PT_OP_CODE_SLICE);END GENERATE;ONE_OPERATION:IF
 IIO0IIO0I000OIOIl1O00010Ill11IIIII=1 GENERATE BEGIN III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_OP_CODE_SLICE)<=FLT_PT_GET_OP_CODE(C_HAS_ADD,C_HAS_SUBTRACT,
C_HAS_MULTIPLY,C_HAS_DIVIDE,C_HAS_SQRT,C_HAS_COMPARE,C_HAS_FIX_TO_FLT,C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT);END GENERATE;ROUND_MODE:IF
 C_OPTIMIZATION=FLT_PT_COMBINED GENERATE III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_ROUND_MODE_SLICE)<=OPERATION(FLT_PT_ROUND_MODE_SLICE);END GENERATE;
SPECIAL:IF C_OPTIMIZATION=FLT_PT_COMBINED GENERATE III0IOl1OI0OO01O10OIlO0lO0OOIOIIII(FLT_PT_SPECIAL_SLICE)<=OPERATION(FLT_PT_SPECIAL_SLICE);END GENERATE
;FP_OP:FLT_PT_OPERATOR_V4_0 GENERIC MAP(C_FAMILY=>C_XDEVICEFAMILY,C_HAS_ADD=>C_HAS_ADD,C_HAS_SUBTRACT=>C_HAS_SUBTRACT,C_HAS_MULTIPLY
=>C_HAS_MULTIPLY,C_HAS_DIVIDE=>C_HAS_DIVIDE,C_HAS_SQRT=>C_HAS_SQRT,C_HAS_COMPARE=>C_HAS_COMPARE,C_HAS_FIX_TO_FLT=>C_HAS_FIX_TO_FLT,
C_HAS_FLT_TO_FIX=>C_HAS_FLT_TO_FIX,C_HAS_FLT_TO_FLT=>C_HAS_FLT_TO_FLT,C_RESULT_WIDTH=>C_RESULT_WIDTH,C_RESULT_FRACTION_WIDTH=>
C_RESULT_FRACTION_WIDTH,C_A_WIDTH=>IO0lIIllO0OIlIO0I1l0IIlII0l1IOIIII,C_A_FRACTION_WIDTH=>IOlI1IlIO1O010Il1III1O0lO001IOIIII,C_B_WIDTH=>IO0lIIllO0OIlIO0I1l0IIlII0l1IOIIII,C_B_FRACTION_WIDTH=>
IOlI1IlIO1O010Il1III1O0lO001IOIIII,C_OPTIMIZATION=>C_OPTIMIZATION,C_MULT_USAGE=>C_MULT_USAGE,C_HAS_STATUS=>C_HAS_STATUS,C_STATUS_EARLY=>
C_STATUS_EARLY,C_LATENCY=>C_LATENCY,C_RATE=>C_RATE)PORT MAP(A=>A,B=>IO00l1llO0I0OOOI0II0I0O110111IIIII,OPERATION=>III0IOl1OI0OO01O10OIlO0lO0OOIOIIII,OPERATION_ND=>IOII10010000l0II10OlOOllOl1IOIIIII,
OPERATION_RFD=>IOI1l0lII1II11Ill10III0111II1IIIII,CLK=>CLK,CE=>IOIOO1ll1O0Il0100001l1l1O1IIOOIIII,SCLR=>IO1lO0OOOI1111lOOl0lO00Il011IIIIII,RESULT=>RESULT,STATUS=>IIll0O11I1IlIOOl1l100lOIOI1IIOIIII,EXCEPTION=>IO0Oll1llll1l100Il00OO110lO10IIIII,UNDERFLOW
=>IIlIl1100IO000lIO0l10IO1Ol01IOIIII,OVERFLOW=>IO0Il0OI0IOI0O1OIlO1I1IIO000lIIIII,INVALID_OP=>II1OO0I1Ill1I01lO1l0IllOlO11IIIIII,DIVIDE_BY_ZERO=>IOI0l1OOO0lllllI1l1OIOO0I1Il1IIIII,RDY=>IO1I01IOIlI0llO0OI0l10l00IlI0IIIII);END;
